/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.modules.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.TrialSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.purpurmc.purpurextras.PurpurConfig;
import org.purpurmc.purpurextras.PurpurExtras;
import org.purpurmc.purpurextras.modules.PurpurExtrasModule;
import org.purpurmc.purpurextras.util.MessageType;

public class SpawnersProtectionModule
implements PurpurExtrasModule,
Listener {
    private final Component message;
    private MessageType messageType;
    private final boolean allowBreakingInSneak;
    private final boolean blocksImmuneToExplosions;
    private final Permission protectionBypassPermission = new Permission("purpurextras.spawnerprotectionbypass", "Players with this permission will be able to destroy spawners", PermissionDefault.OP);

    public SpawnersProtectionModule() {
        PurpurConfig config = PurpurExtras.getPurpurConfig();
        String defaultMessage = "<red>Prevented you from breaking this block. Sneak to break it anyway.";
        this.message = MiniMessage.miniMessage().deserialize((Object)config.getString("settings.protect-spawners.message", defaultMessage));
        this.allowBreakingInSneak = config.getBoolean("settings.protect-spawners.allow-breaking-in-sneak", true);
        this.blocksImmuneToExplosions = config.getBoolean("settings.protect-spawners.immune-to-explosions", false);
        try {
            this.messageType = MessageType.valueOf(config.getString("settings.protect-spawners.message-type", "CHAT").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.messageType = MessageType.CHAT;
        }
    }

    @Override
    public void enable() {
        PurpurExtras plugin = PurpurExtras.getInstance();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public boolean shouldEnable() {
        this.registerPermissions(this.protectionBypassPermission);
        return PurpurExtras.getPurpurConfig().getBoolean("settings.protect-spawners.enabled", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDestroySpawner(BlockBreakEvent event) {
        if (this.isProtected(event.getBlock().getState(true))) {
            this.handleLootBlockDestruction(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplodingSpawner(EntityExplodeEvent event) {
        if (!this.blocksImmuneToExplosions) {
            return;
        }
        event.blockList().removeIf(block -> this.isProtected(block.getState(true)));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplodingSpawner(BlockExplodeEvent event) {
        if (!this.blocksImmuneToExplosions) {
            return;
        }
        event.blockList().removeIf(block -> this.isProtected(block.getState(true)));
    }

    private void handleLootBlockDestruction(BlockBreakEvent event) {
        if (event.getPlayer().hasPermission(this.protectionBypassPermission)) {
            return;
        }
        if (this.allowBreakingInSneak && event.getPlayer().isSneaking()) {
            return;
        }
        event.setCancelled(true);
        switch (this.messageType) {
            case CHAT: {
                event.getPlayer().sendMessage(this.message);
                break;
            }
            case ACTION_BAR: {
                event.getPlayer().sendActionBar(this.message);
            }
        }
    }

    private boolean isProtected(BlockState blockState) {
        return blockState instanceof CreatureSpawner || blockState instanceof TrialSpawner;
    }
}

