/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.util;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.potion.PotionEffect;

public class EntityStatePreserverUtil {
    private EntityStatePreserverUtil() {
    }

    public static void preserveEntityState(LivingEntity oldEntity, LivingEntity transformedEntity) {
        if (oldEntity == null || transformedEntity == null) {
            return;
        }
        EntityStatePreserverUtil.preserveGeneralProperties(oldEntity, transformedEntity);
    }

    private static void preserveGeneralProperties(LivingEntity oldEntity, LivingEntity transformedEntity) {
        EntityStatePreserverUtil.preserveEquipment(oldEntity.getEquipment(), (Entity)transformedEntity);
        EntityStatePreserverUtil.preserveHealth(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preserveSurvivalState(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preservePotionEffect(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preserveFlags(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preserveFireAndFreeze(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preservePoseAndRotation(oldEntity, transformedEntity);
        EntityStatePreserverUtil.preserveExtraStates(oldEntity, transformedEntity);
    }

    private static void preserveExtraStates(LivingEntity oldEntity, LivingEntity transformedEntity) {
        EntityStatePreserverUtil.preserveVelocity(oldEntity, transformedEntity);
        transformedEntity.setPortalCooldown(oldEntity.getPortalCooldown());
        transformedEntity.setAI(oldEntity.hasAI());
        transformedEntity.setGliding(oldEntity.isGliding());
        transformedEntity.setSneaking(oldEntity.isSneaking());
    }

    private static void preserveSurvivalState(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.setAbsorptionAmount(oldEntity.getAbsorptionAmount());
        transformedEntity.setMaximumAir(oldEntity.getMaximumAir());
        transformedEntity.setRemainingAir(oldEntity.getRemainingAir());
        transformedEntity.setNoDamageTicks(oldEntity.getNoDamageTicks());
    }

    private static void preserveVelocity(LivingEntity oldEntity, LivingEntity transformedEntity) {
        if (oldEntity.getType() == transformedEntity.getType()) {
            transformedEntity.setVelocity(oldEntity.getVelocity());
        }
    }

    private static void preservePoseAndRotation(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.setPose(oldEntity.getPose());
        transformedEntity.setRotation(oldEntity.getLocation().getYaw(), oldEntity.getLocation().getPitch());
    }

    private static void preserveFireAndFreeze(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.setFireTicks(oldEntity.getFireTicks());
        transformedEntity.setFreezeTicks(oldEntity.getFreezeTicks());
    }

    private static void preserveFlags(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.setCustomNameVisible(oldEntity.isCustomNameVisible());
        transformedEntity.setGlowing(oldEntity.isGlowing());
        transformedEntity.setGravity(oldEntity.hasGravity());
        transformedEntity.setCollidable(oldEntity.isCollidable());
        transformedEntity.setSilent(oldEntity.isSilent());
        transformedEntity.setInvisible(oldEntity.isInvisible());
        transformedEntity.setInvulnerable(oldEntity.isInvulnerable());
        transformedEntity.setPersistent(oldEntity.isPersistent());
    }

    private static void preservePotionEffect(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.getActivePotionEffects().forEach(pe -> transformedEntity.removePotionEffect(pe.getType()));
        for (PotionEffect effect : oldEntity.getActivePotionEffects()) {
            transformedEntity.addPotionEffect(effect);
        }
    }

    private static void preserveHealth(LivingEntity oldEntity, LivingEntity transformedEntity) {
        transformedEntity.setHealth(oldEntity.getHealth());
    }

    private static void preserveEquipment(EntityEquipment oldEquipment, Entity spawnedEntity) {
        if (spawnedEntity instanceof LivingEntity) {
            EntityEquipment newEquipment;
            LivingEntity newEntity = (LivingEntity)spawnedEntity;
            if (oldEquipment != null && (newEquipment = newEntity.getEquipment()) != null) {
                newEquipment.setArmorContents(oldEquipment.getArmorContents());
                newEquipment.setHelmetDropChance(oldEquipment.getHelmetDropChance());
                newEquipment.setChestplateDropChance(oldEquipment.getChestplateDropChance());
                newEquipment.setLeggingsDropChance(oldEquipment.getLeggingsDropChance());
                newEquipment.setBootsDropChance(oldEquipment.getBootsDropChance());
                newEquipment.setItemInMainHand(oldEquipment.getItemInMainHand());
                newEquipment.setItemInMainHandDropChance(oldEquipment.getItemInMainHandDropChance());
                newEquipment.setItemInOffHand(oldEquipment.getItemInOffHand());
                newEquipment.setItemInOffHandDropChance(oldEquipment.getItemInOffHandDropChance());
            }
        }
    }
}

