/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpurextras.util;

import com.destroystokyo.paper.MaterialTags;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemStackUtil {
    public static boolean damage(ItemStack itemStack, int amount, boolean ignoreUnbreaking) {
        ItemMeta meta = itemStack.getItemMeta();
        Damageable damageable = (Damageable)itemStack.getItemMeta();
        if (amount > 0) {
            int unbreaking = meta.getEnchantLevel(Enchantment.UNBREAKING);
            int reduce = 0;
            for (int i = 0; unbreaking > 0 && i < amount; ++i) {
                if (!ItemStackUtil.reduceDamage(itemStack, ThreadLocalRandom.current(), unbreaking)) continue;
                ++reduce;
            }
            if ((amount -= reduce) <= 0) {
                return ItemStackUtil.isBroke(itemStack, damageable.getDamage());
            }
        }
        int damage = damageable.getDamage() + amount;
        damageable.setDamage(damage);
        itemStack.setItemMeta((ItemMeta)damageable);
        return ItemStackUtil.isBroke(itemStack, damage);
    }

    public static boolean isBroke(ItemStack itemStack, int damage) {
        if (damage > itemStack.getType().getMaxDurability()) {
            if (itemStack.getAmount() > 0) {
                itemStack.setAmount(0);
            }
            return true;
        }
        return false;
    }

    private static boolean reduceDamage(ItemStack itemStack, Random random, int unbreaking) {
        if (MaterialTags.ARMOR.isTagged(itemStack.getType())) {
            return random.nextFloat() < 0.6f;
        }
        return random.nextInt(unbreaking + 1) > 0;
    }
}

