/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.checker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.naocraftlab.foggypalegarden.util.FpgFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;

public final class FogOcclusionChecker {
    public static boolean isSodiumFogOcclusionEnabled() {
        return FogOcclusionChecker.isFogOcclusionEnabled("sodium");
    }

    public static boolean isEmbeddiumFogOcclusionEnabled() {
        return FogOcclusionChecker.isFogOcclusionEnabled("embeddium");
    }

    public static boolean isRubidiumFogOcclusionEnabled() {
        return FogOcclusionChecker.isFogOcclusionEnabled("rubidium");
    }

    private static boolean isFogOcclusionEnabled(String modId) {
        Path optionsFile = Paths.get("./config", new String[0]).resolve(modId + "-options.json");
        if (!Files.exists(optionsFile, new LinkOption[0])) {
            return false;
        }
        String optionsContent = FpgFiles.readString(optionsFile);
        JsonObject options = JsonParser.parseString((String)optionsContent).getAsJsonObject();
        return options.getAsJsonObject("performance").get("use_fog_occlusion").getAsBoolean();
    }

    @Generated
    private FogOcclusionChecker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

