/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.naocraftlab.foggypalegarden.AbstractCommand;
import com.naocraftlab.foggypalegarden.config.ConfigFacade;
import com.naocraftlab.foggypalegarden.converter.GameTypeConverter;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameType;

public class FpgNoFogGameModeCommand
extends AbstractCommand {
    private static final SuggestionProvider<CommandSourceStack> GAME_MODE_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest(Stream.of(GameType.values()).map(Enum::name), (SuggestionsBuilder)builder);
    public static final LiteralArgumentBuilder<CommandSourceStack> INSTANCE = (LiteralArgumentBuilder)Commands.literal((String)BASE_COMMAND).then(((LiteralArgumentBuilder)Commands.literal((String)NO_FOG_GAME_MODE_COMMAND).executes(FpgNoFogGameModeCommand::listNoFogGameModes)).then(Commands.argument((String)NO_FOG_GAME_MODE_COMMAND, (ArgumentType)StringArgumentType.string()).suggests(GAME_MODE_SUGGESTIONS).executes(FpgNoFogGameModeCommand::toggleFogForGameMode)));

    private static int toggleFogForGameMode(CommandContext<CommandSourceStack> context) {
        String argumentValue = StringArgumentType.getString(context, (String)NO_FOG_GAME_MODE_COMMAND);
        try {
            GameType gameMode = GameType.valueOf((String)argumentValue);
            String gameModeName = gameMode.getShortDisplayName().getString();
            if (ConfigFacade.configFacade().toggleNoFogGameMode(GameTypeConverter.toDomainGameType(gameMode))) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.noFogGameMode.off", (Object[])new Object[]{gameModeName}).withStyle(ChatFormatting.GRAY), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.noFogGameMode.on", (Object[])new Object[]{gameModeName}).withStyle(ChatFormatting.GREEN), false);
            }
            ConfigFacade.configFacade().save();
            return 1;
        }
        catch (Exception e) {
            String gameModes = Stream.of(GameType.values()).map(Enum::name).collect(Collectors.joining("\n"));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"fpg.command.noFogGameMode.notFound", (Object[])new Object[]{argumentValue, gameModes}));
            return 0;
        }
    }

    private static int listNoFogGameModes(CommandContext<CommandSourceStack> context) {
        if (!ConfigFacade.configFacade().noFogGameModes().isEmpty()) {
            String noFogGameModes = ConfigFacade.configFacade().noFogGameModes().stream().map(GameTypeConverter::toGameType).map(GameType::getShortDisplayName).map(Component::getString).collect(Collectors.joining("\n"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.noFogGameMode.list", (Object[])new Object[]{noFogGameModes}), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.noFogGameMode.listEmpty").withStyle(ChatFormatting.GREEN), false);
        }
        return 1;
    }
}

