/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.naocraftlab.foggypalegarden.AbstractCommand;
import com.naocraftlab.foggypalegarden.config.ConfigFacade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class FpgPresetCommand
extends AbstractCommand {
    private static final SuggestionProvider<CommandSourceStack> PRESET_SUGGESTIONS = (context, builder) -> {
        List<String> presets = ConfigFacade.configFacade().getAvailablePresetCodes();
        return SharedSuggestionProvider.suggest(presets, (SuggestionsBuilder)builder);
    };
    public static final LiteralArgumentBuilder<CommandSourceStack> INSTANCE = (LiteralArgumentBuilder)Commands.literal((String)BASE_COMMAND).then(((LiteralArgumentBuilder)Commands.literal((String)PRESET_COMMAND).then(Commands.argument((String)PRESET_COMMAND, (ArgumentType)StringArgumentType.string()).suggests(PRESET_SUGGESTIONS).executes(FpgPresetCommand::setPreset))).executes(context -> {
        String currentPreset = ConfigFacade.configFacade().getCurrentPreset().getCode();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.preset.current", (Object[])new Object[]{currentPreset}), false);
        return 1;
    }));

    private static int setPreset(CommandContext<CommandSourceStack> context) {
        String preset = StringArgumentType.getString(context, (String)PRESET_COMMAND);
        try {
            if (ConfigFacade.configFacade().setCurrentPreset(preset)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.preset.applied", (Object[])new Object[]{preset}).withStyle(ChatFormatting.GREEN), false);
                ConfigFacade.configFacade().save();
                return 1;
            }
            String allPresets = String.join((CharSequence)"\n", ConfigFacade.configFacade().getAvailablePresetCodes());
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"fpg.command.preset.notFound", (Object[])new Object[]{preset, allPresets}).withStyle(ChatFormatting.RED));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"fpg.command.preset.exception", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            return 0;
        }
    }
}

