/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.naocraftlab.foggypalegarden.AbstractCommand;
import com.naocraftlab.foggypalegarden.config.ConfigFacade;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class FpgReloadConfigCommand
extends AbstractCommand {
    public static final LiteralArgumentBuilder<CommandSourceStack> INSTANCE = (LiteralArgumentBuilder)Commands.literal((String)BASE_COMMAND).then(Commands.literal((String)RELOAD_CONFIG_COMMAND).executes(FpgReloadConfigCommand::reloadConfig));

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        try {
            ConfigFacade.configFacade().load();
            String currentPreset = ConfigFacade.configFacade().getCurrentPreset().getCode();
            String allPresets = ConfigFacade.configFacade().getAvailablePresetCodes().stream().collect(Collectors.joining("\n"));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"fpg.command.reloadConfig.success", (Object[])new Object[]{currentPreset, allPresets}).withStyle(ChatFormatting.GREEN), false);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"fpg.command.reloadConfig.exception", (Object[])new Object[]{e.getMessage()}).withStyle(ChatFormatting.RED));
            return 0;
        }
    }
}

