/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.config;

import com.naocraftlab.foggypalegarden.FoggyPaleGarden;
import com.naocraftlab.foggypalegarden.config.main.MainConfig;
import com.naocraftlab.foggypalegarden.config.main.MainConfigV3;
import com.naocraftlab.foggypalegarden.config.preset.FogPresetV3;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSource;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSourceConfig;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSourceEmbedded;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSourceResourcePack;
import com.naocraftlab.foggypalegarden.domain.model.GameType;
import com.naocraftlab.foggypalegarden.domain.service.FogService;
import com.naocraftlab.foggypalegarden.util.FpgFiles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ConfigFacade {
    private static final Path CONFIG_FILE_PTAH = FoggyPaleGarden.CONFIG_DIR.resolve("foggypalegarden.json");
    private static final int CURRENT_MAIN_CONFIG_VERSION = 3;
    private static final int CURRENT_PRESET_VERSION = 3;
    private static ConfigFacade instance = null;
    private final List<Consumer<FogPresetV3>> listeners;
    private final PresetSource<FogPresetV3> embeddedPresetSource = new PresetSourceEmbedded();
    private final PresetSource<FogPresetV3> resourcePackPresetSource = new PresetSourceResourcePack<FogPresetV3>(3, FogPresetV3.class);
    private final PresetSource<FogPresetV3> configPresetSource = new PresetSourceConfig<FogPresetV3>(3, FogPresetV3.class);
    private MainConfigV3 mainConfig = new MainConfigV3("FPG_STEPHEN_KING", Set.of());
    private Map<String, PresetSource.PresetBox<FogPresetV3>> presets = new HashMap<String, PresetSource.PresetBox<FogPresetV3>>();

    private ConfigFacade(List<Consumer<FogPresetV3>> listeners) {
        this.listeners = listeners;
        this.load();
    }

    @NotNull
    public static ConfigFacade configFacade() {
        if (instance == null) {
            instance = new ConfigFacade(List.of(FogService::onCurrentPresetChange));
        }
        return instance;
    }

    public void load() {
        this.loadConfig();
        this.loadPresets();
        this.backoffIfPresetDeleted();
        this.notifyCurrentPresetListeners(this.getCurrentPreset().getPreset());
    }

    private void backoffIfPresetDeleted() {
        if (!this.presets.containsKey(this.mainConfig.getPreset())) {
            this.mainConfig = this.mainConfig.withPreset("FPG_STEPHEN_KING");
            this.saveMainConfig();
        }
    }

    private void loadConfig() {
        MainConfig existsMainConfig;
        if (Files.exists(CONFIG_FILE_PTAH, new LinkOption[0]) && (existsMainConfig = (MainConfig)FoggyPaleGarden.GSON.fromJson(FpgFiles.readString(CONFIG_FILE_PTAH), MainConfig.class)).getVersion() == 3) {
            this.mainConfig = (MainConfigV3)FoggyPaleGarden.GSON.fromJson(FpgFiles.readString(CONFIG_FILE_PTAH), MainConfigV3.class);
        }
        this.saveMainConfig();
    }

    private void loadPresets() {
        this.presets = new HashMap<String, PresetSource.PresetBox<FogPresetV3>>();
        this.configPresetSource.load().forEach(preset -> this.presets.put(preset.getCode(), (PresetSource.PresetBox<FogPresetV3>)preset));
        this.resourcePackPresetSource.load().forEach(this::putOrReplaceToBackup);
        this.embeddedPresetSource.load().forEach(this::putOrReplaceToBackup);
        this.savePresets();
    }

    private void putOrReplaceToBackup(PresetSource.PresetBox<FogPresetV3> preset) {
        PresetSource.PresetBox<FogPresetV3> exists = this.presets.get(preset.getCode());
        if (exists != null && exists.getSourceType() == PresetSource.PresetSourceType.CONFIG) {
            String backupPresetCode = exists.getCode() + "_BACKUP";
            Path backupPresetPath = PresetSourceConfig.PRESET_DIR_PATH.resolve(backupPresetCode + ".json");
            FpgFiles.move(Paths.get(exists.getPath(), new String[0]), backupPresetPath);
            PresetSource.PresetBox<FogPresetV3> backupPreset = PresetSource.PresetBox.builder().sourceType(exists.getSourceType()).code(backupPresetCode).path(backupPresetPath.toString()).preset(exists.getPreset().withCode(backupPresetCode)).build();
            this.presets.put(backupPreset.getCode(), backupPreset);
        }
        this.presets.put(preset.getCode(), preset);
    }

    public void save() {
        this.saveMainConfig();
        this.savePresets();
    }

    private void saveMainConfig() {
        FpgFiles.writeString(CONFIG_FILE_PTAH, FoggyPaleGarden.GSON.toJson((Object)this.mainConfig));
    }

    private void savePresets() {
        this.configPresetSource.save(this.presets.values());
    }

    @NotNull
    public List<GameType> noFogGameModes() {
        return this.mainConfig.getNoFogGameModes().stream().sorted().toList();
    }

    public boolean isNoFogGameMode(@NotNull GameType gameMode) {
        return this.mainConfig.getNoFogGameModes().contains((Object)gameMode);
    }

    public void noFogGameModes(Set<GameType> gameModes) {
        this.mainConfig = this.mainConfig.withNoFogGameModes(gameModes);
    }

    public boolean toggleNoFogGameMode(@NotNull GameType gameMode) {
        HashSet<GameType> noFogGameModes = new HashSet<GameType>(this.mainConfig.getNoFogGameModes());
        if (this.isNoFogGameMode(gameMode)) {
            noFogGameModes.remove((Object)gameMode);
            this.mainConfig = this.mainConfig.withNoFogGameModes(noFogGameModes);
            return false;
        }
        noFogGameModes.add(gameMode);
        this.mainConfig = this.mainConfig.withNoFogGameModes(noFogGameModes);
        return true;
    }

    @NotNull
    public List<String> getAvailablePresetCodes() {
        return this.presets.keySet().stream().sorted().toList();
    }

    @NotNull
    public PresetSource.PresetBox<FogPresetV3> getCurrentPreset() {
        return this.presets.get(this.mainConfig.getPreset());
    }

    public boolean setCurrentPreset(@NotNull String presetCode) {
        if (this.presets.containsKey(presetCode)) {
            this.mainConfig = this.mainConfig.withPreset(presetCode);
            this.notifyCurrentPresetListeners(this.getCurrentPreset().getPreset());
            return true;
        }
        return false;
    }

    private void notifyCurrentPresetListeners(FogPresetV3 currentPreset) {
        for (Consumer<FogPresetV3> listener : this.listeners) {
            listener.accept(currentPreset);
        }
    }
}

