/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.config.preset;

import com.naocraftlab.foggypalegarden.config.preset.FogPreset;
import com.naocraftlab.foggypalegarden.domain.model.Environment;
import com.naocraftlab.foggypalegarden.domain.model.FogShape;
import com.naocraftlab.foggypalegarden.exception.FoggyPaleGardenConfigurationException;
import com.naocraftlab.foggypalegarden.util.FpgStrings;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.world.Difficulty;
import org.jetbrains.annotations.NotNull;

public final class FogPresetV3
extends FogPreset {
    @NotNull
    private final List<Binding> bindings;

    public FogPresetV3(@NotNull String code, @NotNull List<Binding> bindings) {
        super(3, code);
        this.bindings = bindings;
    }

    public FogPresetV3 withCode(String code) {
        return new FogPresetV3(code, this.bindings);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.code == null || this.code.trim().isEmpty()) {
            throw new FoggyPaleGardenConfigurationException("Preset code is not defined");
        }
        if (this.bindings == null || this.bindings.isEmpty()) {
            throw new FoggyPaleGardenConfigurationException("Preset bindings are not defined");
        }
        for (Binding binding : this.bindings) {
            binding.validate();
        }
    }

    @Generated
    protected FogPresetV3(FogPresetV3Builder<?, ?> b) {
        super(b);
        this.bindings = b.bindings;
        if (this.bindings == null) {
            throw new NullPointerException("bindings is marked non-null but is null");
        }
    }

    @Generated
    public static FogPresetV3Builder<?, ?> builder() {
        return new FogPresetV3BuilderImpl();
    }

    @NotNull
    @Generated
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    @Generated
    public String toString() {
        return "FogPresetV3(super=" + super.toString() + ", bindings=" + String.valueOf(this.getBindings()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FogPresetV3)) {
            return false;
        }
        FogPresetV3 other = (FogPresetV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Binding> this$bindings = this.bindings;
        List<Binding> other$bindings = other.bindings;
        return !(this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FogPresetV3;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Binding> $bindings = this.bindings;
        result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
        return result;
    }

    public static class Binding {
        private final Condition condition;
        private final Float startDistance;
        private final Float endDistance;
        private final Float opacity;
        private final Float encapsulationSpeed;
        private final Brightness brightness;
        private final Color color;
        private final FogShape shape;

        public Condition condition() {
            return this.condition;
        }

        public Float startDistance() {
            return Float.valueOf(this.startDistance == null ? 0.0f : this.startDistance.floatValue());
        }

        public Float endDistance() {
            return Float.valueOf(this.endDistance == null ? 0.0f : this.endDistance.floatValue());
        }

        public Float opacity() {
            return Float.valueOf(this.opacity == null ? 100.0f : this.opacity.floatValue());
        }

        public Float encapsulationSpeed() {
            return Float.valueOf(this.encapsulationSpeed == null ? 6.0f : this.encapsulationSpeed.floatValue());
        }

        public Brightness brightness() {
            return this.brightness == null ? new Brightness(Brightness.BrightnessMode.BY_GAME_FOG, null, null) : this.brightness;
        }

        public Color color() {
            return this.color == null ? new Color(Color.ColorMode.BY_GAME_FOG, null) : this.color;
        }

        public FogShape shape() {
            return this.shape == null ? FogShape.SPHERE : this.shape;
        }

        public void validate() {
            if (this.condition == null) {
                throw new FoggyPaleGardenConfigurationException("Binding condition is not defined");
            }
            this.condition.validate();
            if (this.startDistance().floatValue() < 0.0f) {
                throw new FoggyPaleGardenConfigurationException("Binding start distance is negative");
            }
            if (this.startDistance().floatValue() > this.endDistance().floatValue()) {
                throw new FoggyPaleGardenConfigurationException("Binding start distance is greater than end distance");
            }
            if (this.opacity().floatValue() <= 0.0f || this.opacity().floatValue() > 100.0f) {
                throw new FoggyPaleGardenConfigurationException("Binding opacity is out of range (0, 100]");
            }
            if (this.encapsulationSpeed().floatValue() <= 0.0f) {
                throw new FoggyPaleGardenConfigurationException("Binding encapsulation speed is non-positive");
            }
            this.brightness().validate();
            this.color().validate();
        }

        @Generated
        Binding(Condition condition, Float startDistance, Float endDistance, Float opacity, Float encapsulationSpeed, Brightness brightness, Color color, FogShape shape) {
            this.condition = condition;
            this.startDistance = startDistance;
            this.endDistance = endDistance;
            this.opacity = opacity;
            this.encapsulationSpeed = encapsulationSpeed;
            this.brightness = brightness;
            this.color = color;
            this.shape = shape;
        }

        @Generated
        public static BindingBuilder builder() {
            return new BindingBuilder();
        }

        @Generated
        public Condition getCondition() {
            return this.condition;
        }

        @Generated
        public Float getStartDistance() {
            return this.startDistance;
        }

        @Generated
        public Float getEndDistance() {
            return this.endDistance;
        }

        @Generated
        public Float getOpacity() {
            return this.opacity;
        }

        @Generated
        public Float getEncapsulationSpeed() {
            return this.encapsulationSpeed;
        }

        @Generated
        public Brightness getBrightness() {
            return this.brightness;
        }

        @Generated
        public Color getColor() {
            return this.color;
        }

        @Generated
        public FogShape getShape() {
            return this.shape;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Float this$startDistance = this.getStartDistance();
            Float other$startDistance = other.getStartDistance();
            if (this$startDistance == null ? other$startDistance != null : !((Object)this$startDistance).equals(other$startDistance)) {
                return false;
            }
            Float this$endDistance = this.getEndDistance();
            Float other$endDistance = other.getEndDistance();
            if (this$endDistance == null ? other$endDistance != null : !((Object)this$endDistance).equals(other$endDistance)) {
                return false;
            }
            Float this$opacity = this.getOpacity();
            Float other$opacity = other.getOpacity();
            if (this$opacity == null ? other$opacity != null : !((Object)this$opacity).equals(other$opacity)) {
                return false;
            }
            Float this$encapsulationSpeed = this.getEncapsulationSpeed();
            Float other$encapsulationSpeed = other.getEncapsulationSpeed();
            if (this$encapsulationSpeed == null ? other$encapsulationSpeed != null : !((Object)this$encapsulationSpeed).equals(other$encapsulationSpeed)) {
                return false;
            }
            Condition this$condition = this.getCondition();
            Condition other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
                return false;
            }
            Brightness this$brightness = this.getBrightness();
            Brightness other$brightness = other.getBrightness();
            if (this$brightness == null ? other$brightness != null : !((Object)this$brightness).equals(other$brightness)) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
                return false;
            }
            FogShape this$shape = this.getShape();
            FogShape other$shape = other.getShape();
            return !(this$shape == null ? other$shape != null : !((Object)((Object)this$shape)).equals((Object)other$shape));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Binding;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Float $startDistance = this.getStartDistance();
            result = result * 59 + ($startDistance == null ? 43 : ((Object)$startDistance).hashCode());
            Float $endDistance = this.getEndDistance();
            result = result * 59 + ($endDistance == null ? 43 : ((Object)$endDistance).hashCode());
            Float $opacity = this.getOpacity();
            result = result * 59 + ($opacity == null ? 43 : ((Object)$opacity).hashCode());
            Float $encapsulationSpeed = this.getEncapsulationSpeed();
            result = result * 59 + ($encapsulationSpeed == null ? 43 : ((Object)$encapsulationSpeed).hashCode());
            Condition $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
            Brightness $brightness = this.getBrightness();
            result = result * 59 + ($brightness == null ? 43 : ((Object)$brightness).hashCode());
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            FogShape $shape = this.getShape();
            result = result * 59 + ($shape == null ? 43 : ((Object)((Object)$shape)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FogPresetV3.Binding(condition=" + String.valueOf(this.getCondition()) + ", startDistance=" + this.getStartDistance() + ", endDistance=" + this.getEndDistance() + ", opacity=" + this.getOpacity() + ", encapsulationSpeed=" + this.getEncapsulationSpeed() + ", brightness=" + String.valueOf(this.getBrightness()) + ", color=" + String.valueOf(this.getColor()) + ", shape=" + String.valueOf((Object)this.getShape()) + ")";
        }

        public static class Condition {
            private final Set<String> dimensionIn;
            private final Set<String> biomeIdIn;
            private final Temperature biomeTemperature;
            private final Set<Difficulty> difficultyIn;
            private final Set<Weather> weatherIn;
            private final TimePeriod timeIn;
            private final SkyLightLevel skyLightLevel;
            private final Height height;
            private final SurfaceHeight surfaceHeight;
            private final List<Condition> and;
            private final List<Condition> or;
            private final Condition not;

            public Set<String> dimensionIn() {
                return this.dimensionIn;
            }

            public Set<String> biomeIdIn() {
                return this.biomeIdIn;
            }

            public Temperature biomeTemperature() {
                return this.biomeTemperature;
            }

            public Set<Difficulty> difficultyIn() {
                return this.difficultyIn;
            }

            public Set<Weather> weatherIn() {
                return this.weatherIn;
            }

            public TimePeriod timeIn() {
                return this.timeIn;
            }

            public SkyLightLevel skyLightLevel() {
                return this.skyLightLevel;
            }

            public Height height() {
                return this.height;
            }

            public SurfaceHeight surfaceHeight() {
                return this.surfaceHeight;
            }

            public List<Condition> and() {
                return this.and;
            }

            public List<Condition> or() {
                return this.or;
            }

            public Condition not() {
                return this.not;
            }

            public void validate() {
                int filledFields = 0;
                if (this.dimensionIn != null && !this.dimensionIn.isEmpty()) {
                    ++filledFields;
                }
                if (this.biomeTemperature != null) {
                    ++filledFields;
                    this.biomeTemperature.validate();
                }
                if (this.biomeIdIn != null && !this.biomeIdIn.isEmpty()) {
                    ++filledFields;
                }
                if (this.difficultyIn != null && !this.difficultyIn.isEmpty()) {
                    ++filledFields;
                }
                if (this.weatherIn != null && !this.weatherIn.isEmpty()) {
                    ++filledFields;
                }
                if (this.timeIn != null) {
                    ++filledFields;
                    this.timeIn.validate();
                }
                if (this.skyLightLevel != null) {
                    ++filledFields;
                    this.skyLightLevel.validate();
                }
                if (this.height != null) {
                    ++filledFields;
                    this.height.validate();
                }
                if (this.surfaceHeight != null) {
                    ++filledFields;
                    this.surfaceHeight.validate();
                }
                if (this.and != null && !this.and.isEmpty()) {
                    ++filledFields;
                    for (Condition condition : this.and) {
                        if (condition == null) {
                            throw new FoggyPaleGardenConfigurationException("AND list contains a null condition");
                        }
                        condition.validate();
                    }
                }
                if (this.or != null && !this.or.isEmpty()) {
                    ++filledFields;
                    for (Condition condition : this.or) {
                        if (condition == null) {
                            throw new FoggyPaleGardenConfigurationException("OR list contains a null condition");
                        }
                        condition.validate();
                    }
                }
                if (this.not != null) {
                    ++filledFields;
                    this.not.validate();
                }
                if (filledFields != 1) {
                    throw new FoggyPaleGardenConfigurationException("In one instance of condition, only one of the fields should be filled");
                }
            }

            public Predicate<Environment> toPredicate() {
                Number max;
                Number min;
                if (this.and != null && !this.and.isEmpty()) {
                    return this.and.stream().map(Condition::toPredicate).reduce(Predicate::and).orElse(env -> true);
                }
                if (this.or != null && !this.or.isEmpty()) {
                    return this.or.stream().map(Condition::toPredicate).reduce(Predicate::or).orElse(env -> false);
                }
                if (this.not != null) {
                    return this.not.toPredicate().negate();
                }
                Predicate<Environment> predicate = env -> true;
                if (this.dimensionIn != null && !this.dimensionIn.isEmpty()) {
                    predicate = predicate.and(env -> this.dimensionIn.stream().anyMatch(pattern -> FpgStrings.wildcardMatch(env.dimension(), pattern)));
                }
                if (this.biomeIdIn != null && !this.biomeIdIn.isEmpty()) {
                    predicate = predicate.and(env -> this.biomeIdIn.stream().anyMatch(pattern -> FpgStrings.wildcardMatch(env.biome(), pattern)));
                }
                if (this.biomeTemperature != null) {
                    min = this.biomeTemperature.min();
                    max = this.biomeTemperature.max();
                    predicate = predicate.and(arg_0 -> Condition.lambda$toPredicate$7((Float)min, (Float)max, arg_0));
                }
                if (this.difficultyIn != null && !this.difficultyIn.isEmpty()) {
                    predicate = predicate.and(env -> this.difficultyIn.contains(env.difficulty()));
                }
                if (this.weatherIn != null && !this.weatherIn.isEmpty()) {
                    predicate = predicate.and(env -> this.weatherIn.contains((Object)Weather.valueOf(env.weather().name())));
                }
                if (this.timeIn != null) {
                    Long start = this.timeIn.start();
                    Long end = this.timeIn.end();
                    predicate = predicate.and(env -> {
                        long time = env.timeOfDay();
                        if (start <= end) {
                            return time >= start && time <= end;
                        }
                        return time >= start || time <= end;
                    });
                }
                if (this.skyLightLevel != null) {
                    min = this.skyLightLevel.min();
                    max = this.skyLightLevel.max();
                    predicate = predicate.and(arg_0 -> Condition.lambda$toPredicate$11((Integer)min, (Integer)max, arg_0));
                }
                if (this.height != null) {
                    min = this.height.min();
                    max = this.height.max();
                    predicate = predicate.and(arg_0 -> Condition.lambda$toPredicate$12((Double)min, (Double)max, arg_0));
                }
                if (this.surfaceHeight != null) {
                    min = this.surfaceHeight.min();
                    max = this.surfaceHeight.max();
                    predicate = predicate.and(arg_0 -> Condition.lambda$toPredicate$13((Float)min, (Float)max, arg_0));
                }
                return predicate;
            }

            @Generated
            Condition(Set<String> dimensionIn, Set<String> biomeIdIn, Temperature biomeTemperature, Set<Difficulty> difficultyIn, Set<Weather> weatherIn, TimePeriod timeIn, SkyLightLevel skyLightLevel, Height height, SurfaceHeight surfaceHeight, List<Condition> and, List<Condition> or, Condition not) {
                this.dimensionIn = dimensionIn;
                this.biomeIdIn = biomeIdIn;
                this.biomeTemperature = biomeTemperature;
                this.difficultyIn = difficultyIn;
                this.weatherIn = weatherIn;
                this.timeIn = timeIn;
                this.skyLightLevel = skyLightLevel;
                this.height = height;
                this.surfaceHeight = surfaceHeight;
                this.and = and;
                this.or = or;
                this.not = not;
            }

            @Generated
            public static ConditionBuilder builder() {
                return new ConditionBuilder();
            }

            @Generated
            public Set<String> getDimensionIn() {
                return this.dimensionIn;
            }

            @Generated
            public Set<String> getBiomeIdIn() {
                return this.biomeIdIn;
            }

            @Generated
            public Temperature getBiomeTemperature() {
                return this.biomeTemperature;
            }

            @Generated
            public Set<Difficulty> getDifficultyIn() {
                return this.difficultyIn;
            }

            @Generated
            public Set<Weather> getWeatherIn() {
                return this.weatherIn;
            }

            @Generated
            public TimePeriod getTimeIn() {
                return this.timeIn;
            }

            @Generated
            public SkyLightLevel getSkyLightLevel() {
                return this.skyLightLevel;
            }

            @Generated
            public Height getHeight() {
                return this.height;
            }

            @Generated
            public SurfaceHeight getSurfaceHeight() {
                return this.surfaceHeight;
            }

            @Generated
            public List<Condition> getAnd() {
                return this.and;
            }

            @Generated
            public List<Condition> getOr() {
                return this.or;
            }

            @Generated
            public Condition getNot() {
                return this.not;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Condition)) {
                    return false;
                }
                Condition other = (Condition)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Set<String> this$dimensionIn = this.getDimensionIn();
                Set<String> other$dimensionIn = other.getDimensionIn();
                if (this$dimensionIn == null ? other$dimensionIn != null : !((Object)this$dimensionIn).equals(other$dimensionIn)) {
                    return false;
                }
                Set<String> this$biomeIdIn = this.getBiomeIdIn();
                Set<String> other$biomeIdIn = other.getBiomeIdIn();
                if (this$biomeIdIn == null ? other$biomeIdIn != null : !((Object)this$biomeIdIn).equals(other$biomeIdIn)) {
                    return false;
                }
                Temperature this$biomeTemperature = this.getBiomeTemperature();
                Temperature other$biomeTemperature = other.getBiomeTemperature();
                if (this$biomeTemperature == null ? other$biomeTemperature != null : !((Object)this$biomeTemperature).equals(other$biomeTemperature)) {
                    return false;
                }
                Set<Difficulty> this$difficultyIn = this.getDifficultyIn();
                Set<Difficulty> other$difficultyIn = other.getDifficultyIn();
                if (this$difficultyIn == null ? other$difficultyIn != null : !((Object)this$difficultyIn).equals(other$difficultyIn)) {
                    return false;
                }
                Set<Weather> this$weatherIn = this.getWeatherIn();
                Set<Weather> other$weatherIn = other.getWeatherIn();
                if (this$weatherIn == null ? other$weatherIn != null : !((Object)this$weatherIn).equals(other$weatherIn)) {
                    return false;
                }
                TimePeriod this$timeIn = this.getTimeIn();
                TimePeriod other$timeIn = other.getTimeIn();
                if (this$timeIn == null ? other$timeIn != null : !((Object)this$timeIn).equals(other$timeIn)) {
                    return false;
                }
                SkyLightLevel this$skyLightLevel = this.getSkyLightLevel();
                SkyLightLevel other$skyLightLevel = other.getSkyLightLevel();
                if (this$skyLightLevel == null ? other$skyLightLevel != null : !((Object)this$skyLightLevel).equals(other$skyLightLevel)) {
                    return false;
                }
                Height this$height = this.getHeight();
                Height other$height = other.getHeight();
                if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                    return false;
                }
                SurfaceHeight this$surfaceHeight = this.getSurfaceHeight();
                SurfaceHeight other$surfaceHeight = other.getSurfaceHeight();
                if (this$surfaceHeight == null ? other$surfaceHeight != null : !((Object)this$surfaceHeight).equals(other$surfaceHeight)) {
                    return false;
                }
                List<Condition> this$and = this.getAnd();
                List<Condition> other$and = other.getAnd();
                if (this$and == null ? other$and != null : !((Object)this$and).equals(other$and)) {
                    return false;
                }
                List<Condition> this$or = this.getOr();
                List<Condition> other$or = other.getOr();
                if (this$or == null ? other$or != null : !((Object)this$or).equals(other$or)) {
                    return false;
                }
                Condition this$not = this.getNot();
                Condition other$not = other.getNot();
                return !(this$not == null ? other$not != null : !((Object)this$not).equals(other$not));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Condition;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Set<String> $dimensionIn = this.getDimensionIn();
                result = result * 59 + ($dimensionIn == null ? 43 : ((Object)$dimensionIn).hashCode());
                Set<String> $biomeIdIn = this.getBiomeIdIn();
                result = result * 59 + ($biomeIdIn == null ? 43 : ((Object)$biomeIdIn).hashCode());
                Temperature $biomeTemperature = this.getBiomeTemperature();
                result = result * 59 + ($biomeTemperature == null ? 43 : ((Object)$biomeTemperature).hashCode());
                Set<Difficulty> $difficultyIn = this.getDifficultyIn();
                result = result * 59 + ($difficultyIn == null ? 43 : ((Object)$difficultyIn).hashCode());
                Set<Weather> $weatherIn = this.getWeatherIn();
                result = result * 59 + ($weatherIn == null ? 43 : ((Object)$weatherIn).hashCode());
                TimePeriod $timeIn = this.getTimeIn();
                result = result * 59 + ($timeIn == null ? 43 : ((Object)$timeIn).hashCode());
                SkyLightLevel $skyLightLevel = this.getSkyLightLevel();
                result = result * 59 + ($skyLightLevel == null ? 43 : ((Object)$skyLightLevel).hashCode());
                Height $height = this.getHeight();
                result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
                SurfaceHeight $surfaceHeight = this.getSurfaceHeight();
                result = result * 59 + ($surfaceHeight == null ? 43 : ((Object)$surfaceHeight).hashCode());
                List<Condition> $and = this.getAnd();
                result = result * 59 + ($and == null ? 43 : ((Object)$and).hashCode());
                List<Condition> $or = this.getOr();
                result = result * 59 + ($or == null ? 43 : ((Object)$or).hashCode());
                Condition $not = this.getNot();
                result = result * 59 + ($not == null ? 43 : ((Object)$not).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "FogPresetV3.Binding.Condition(dimensionIn=" + String.valueOf(this.getDimensionIn()) + ", biomeIdIn=" + String.valueOf(this.getBiomeIdIn()) + ", biomeTemperature=" + String.valueOf(this.getBiomeTemperature()) + ", difficultyIn=" + String.valueOf(this.getDifficultyIn()) + ", weatherIn=" + String.valueOf(this.getWeatherIn()) + ", timeIn=" + String.valueOf(this.getTimeIn()) + ", skyLightLevel=" + String.valueOf(this.getSkyLightLevel()) + ", height=" + String.valueOf(this.getHeight()) + ", surfaceHeight=" + String.valueOf(this.getSurfaceHeight()) + ", and=" + String.valueOf(this.getAnd()) + ", or=" + String.valueOf(this.getOr()) + ", not=" + String.valueOf(this.getNot()) + ")";
            }

            private static /* synthetic */ boolean lambda$toPredicate$13(Float min, Float max, Environment env) {
                double surfaceHeight = env.heightAboveSurface();
                if (min != null && max != null) {
                    return surfaceHeight >= (double)min.floatValue() && surfaceHeight <= (double)max.floatValue();
                }
                if (min != null) {
                    return surfaceHeight >= (double)min.floatValue();
                }
                return surfaceHeight <= (double)max.floatValue();
            }

            private static /* synthetic */ boolean lambda$toPredicate$12(Double min, Double max, Environment env) {
                double height = env.height();
                if (min != null && max != null) {
                    return height >= min && height <= max;
                }
                if (min != null) {
                    return height >= min;
                }
                return height <= max;
            }

            private static /* synthetic */ boolean lambda$toPredicate$11(Integer min, Integer max, Environment env) {
                int light = env.skyLightLevel();
                if (min != null && max != null) {
                    return light >= min && light <= max;
                }
                if (min != null) {
                    return light >= min;
                }
                return light <= max;
            }

            private static /* synthetic */ boolean lambda$toPredicate$7(Float min, Float max, Environment env) {
                Float temperature = env.biomeTemperature();
                if (min != null && max != null) {
                    return temperature.floatValue() >= min.floatValue() && temperature.floatValue() <= max.floatValue();
                }
                if (min != null) {
                    return temperature.floatValue() >= min.floatValue();
                }
                return temperature.floatValue() <= max.floatValue();
            }

            public static class Temperature {
                private final Float min;
                private final Float max;

                public Float min() {
                    return this.min;
                }

                public Float max() {
                    return this.max;
                }

                public void validate() {
                    if (this.min == null && this.max == null) {
                        throw new FoggyPaleGardenConfigurationException("Temperature min and max cannot be both null");
                    }
                    if (this.min != null && this.max != null && this.min.floatValue() >= this.max.floatValue()) {
                        throw new FoggyPaleGardenConfigurationException("Temperature min must be less than max");
                    }
                }

                @Generated
                Temperature(Float min, Float max) {
                    this.min = min;
                    this.max = max;
                }

                @Generated
                public static TemperatureBuilder builder() {
                    return new TemperatureBuilder();
                }

                @Generated
                public Float getMin() {
                    return this.min;
                }

                @Generated
                public Float getMax() {
                    return this.max;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Temperature)) {
                        return false;
                    }
                    Temperature other = (Temperature)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Float this$min = this.getMin();
                    Float other$min = other.getMin();
                    if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                        return false;
                    }
                    Float this$max = this.getMax();
                    Float other$max = other.getMax();
                    return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Temperature;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Float $min = this.getMin();
                    result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
                    Float $max = this.getMax();
                    result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.Temperature(min=" + this.getMin() + ", max=" + this.getMax() + ")";
                }

                @Generated
                public static class TemperatureBuilder {
                    @Generated
                    private Float min;
                    @Generated
                    private Float max;

                    @Generated
                    TemperatureBuilder() {
                    }

                    @Generated
                    public TemperatureBuilder min(Float min) {
                        this.min = min;
                        return this;
                    }

                    @Generated
                    public TemperatureBuilder max(Float max) {
                        this.max = max;
                        return this;
                    }

                    @Generated
                    public Temperature build() {
                        return new Temperature(this.min, this.max);
                    }

                    @Generated
                    public String toString() {
                        return "FogPresetV3.Binding.Condition.Temperature.TemperatureBuilder(min=" + this.min + ", max=" + this.max + ")";
                    }
                }
            }

            public static class TimePeriod {
                private final Long start;
                private final Long end;

                public Long start() {
                    return this.start;
                }

                public Long end() {
                    return this.end;
                }

                public void validate() {
                    if (this.start == null || this.end == null) {
                        throw new FoggyPaleGardenConfigurationException("TimePeriod start and end cannot be null");
                    }
                    if (this.start < 0L || this.start >= 24000L || this.end < 0L || this.end >= 24000L) {
                        throw new FoggyPaleGardenConfigurationException("TimePeriod start and end must be in the range [0, 24000)");
                    }
                }

                @Generated
                TimePeriod(Long start, Long end) {
                    this.start = start;
                    this.end = end;
                }

                @Generated
                public static TimePeriodBuilder builder() {
                    return new TimePeriodBuilder();
                }

                @Generated
                public Long getStart() {
                    return this.start;
                }

                @Generated
                public Long getEnd() {
                    return this.end;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof TimePeriod)) {
                        return false;
                    }
                    TimePeriod other = (TimePeriod)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$start = this.getStart();
                    Long other$start = other.getStart();
                    if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
                        return false;
                    }
                    Long this$end = this.getEnd();
                    Long other$end = other.getEnd();
                    return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof TimePeriod;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $start = this.getStart();
                    result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
                    Long $end = this.getEnd();
                    result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.TimePeriod(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
                }

                @Generated
                public static class TimePeriodBuilder {
                    @Generated
                    private Long start;
                    @Generated
                    private Long end;

                    @Generated
                    TimePeriodBuilder() {
                    }

                    @Generated
                    public TimePeriodBuilder start(Long start) {
                        this.start = start;
                        return this;
                    }

                    @Generated
                    public TimePeriodBuilder end(Long end) {
                        this.end = end;
                        return this;
                    }

                    @Generated
                    public TimePeriod build() {
                        return new TimePeriod(this.start, this.end);
                    }

                    @Generated
                    public String toString() {
                        return "FogPresetV3.Binding.Condition.TimePeriod.TimePeriodBuilder(start=" + this.start + ", end=" + this.end + ")";
                    }
                }
            }

            public static class SkyLightLevel {
                private final Integer min;
                private final Integer max;

                public Integer min() {
                    return this.min;
                }

                public Integer max() {
                    return this.max;
                }

                public void validate() {
                    if (this.min == null && this.max == null) {
                        throw new FoggyPaleGardenConfigurationException("Sky light level min and max cannot be both null");
                    }
                    if (this.min != null && this.max != null && this.min >= this.max) {
                        throw new FoggyPaleGardenConfigurationException("Sky light level min must be less than max");
                    }
                    if (this.min != null && (this.min < 0 || this.min > 15)) {
                        throw new FoggyPaleGardenConfigurationException("Sky light level min is out of range [0, 15]");
                    }
                    if (this.max != null && (this.max < 0 || this.max > 15)) {
                        throw new FoggyPaleGardenConfigurationException("Sky light level max is out of range [0, 15]");
                    }
                }

                @Generated
                SkyLightLevel(Integer min, Integer max) {
                    this.min = min;
                    this.max = max;
                }

                @Generated
                public static SkyLightLevelBuilder builder() {
                    return new SkyLightLevelBuilder();
                }

                @Generated
                public Integer getMin() {
                    return this.min;
                }

                @Generated
                public Integer getMax() {
                    return this.max;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SkyLightLevel)) {
                        return false;
                    }
                    SkyLightLevel other = (SkyLightLevel)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Integer this$min = this.getMin();
                    Integer other$min = other.getMin();
                    if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                        return false;
                    }
                    Integer this$max = this.getMax();
                    Integer other$max = other.getMax();
                    return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SkyLightLevel;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Integer $min = this.getMin();
                    result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
                    Integer $max = this.getMax();
                    result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.SkyLightLevel(min=" + this.getMin() + ", max=" + this.getMax() + ")";
                }

                @Generated
                public static class SkyLightLevelBuilder {
                    @Generated
                    private Integer min;
                    @Generated
                    private Integer max;

                    @Generated
                    SkyLightLevelBuilder() {
                    }

                    @Generated
                    public SkyLightLevelBuilder min(Integer min) {
                        this.min = min;
                        return this;
                    }

                    @Generated
                    public SkyLightLevelBuilder max(Integer max) {
                        this.max = max;
                        return this;
                    }

                    @Generated
                    public SkyLightLevel build() {
                        return new SkyLightLevel(this.min, this.max);
                    }

                    @Generated
                    public String toString() {
                        return "FogPresetV3.Binding.Condition.SkyLightLevel.SkyLightLevelBuilder(min=" + this.min + ", max=" + this.max + ")";
                    }
                }
            }

            public static class Height {
                private final Double min;
                private final Double max;

                public Double min() {
                    return this.min;
                }

                public Double max() {
                    return this.max;
                }

                public void validate() {
                    if (this.min == null && this.max == null) {
                        throw new FoggyPaleGardenConfigurationException("Height min and max cannot be both null");
                    }
                    if (this.min != null && this.max != null && this.min >= this.max) {
                        throw new FoggyPaleGardenConfigurationException("Height min must be less than max");
                    }
                }

                @Generated
                Height(Double min, Double max) {
                    this.min = min;
                    this.max = max;
                }

                @Generated
                public static HeightBuilder builder() {
                    return new HeightBuilder();
                }

                @Generated
                public Double getMin() {
                    return this.min;
                }

                @Generated
                public Double getMax() {
                    return this.max;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Height)) {
                        return false;
                    }
                    Height other = (Height)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Double this$min = this.getMin();
                    Double other$min = other.getMin();
                    if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                        return false;
                    }
                    Double this$max = this.getMax();
                    Double other$max = other.getMax();
                    return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Height;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Double $min = this.getMin();
                    result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
                    Double $max = this.getMax();
                    result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.Height(min=" + this.getMin() + ", max=" + this.getMax() + ")";
                }

                @Generated
                public static class HeightBuilder {
                    @Generated
                    private Double min;
                    @Generated
                    private Double max;

                    @Generated
                    HeightBuilder() {
                    }

                    @Generated
                    public HeightBuilder min(Double min) {
                        this.min = min;
                        return this;
                    }

                    @Generated
                    public HeightBuilder max(Double max) {
                        this.max = max;
                        return this;
                    }

                    @Generated
                    public Height build() {
                        return new Height(this.min, this.max);
                    }

                    @Generated
                    public String toString() {
                        return "FogPresetV3.Binding.Condition.Height.HeightBuilder(min=" + this.min + ", max=" + this.max + ")";
                    }
                }
            }

            public static class SurfaceHeight {
                private final Float min;
                private final Float max;

                public Float min() {
                    return this.min;
                }

                public Float max() {
                    return this.max;
                }

                public void validate() {
                    if (this.min == null && this.max == null) {
                        throw new FoggyPaleGardenConfigurationException("Surface height min and max cannot be both null");
                    }
                    if (this.min != null && this.max != null && this.min.floatValue() >= this.max.floatValue()) {
                        throw new FoggyPaleGardenConfigurationException("Surface height min must be less than max");
                    }
                    if (this.min != null && this.min.floatValue() < 0.0f) {
                        throw new FoggyPaleGardenConfigurationException("Surface height min is negative");
                    }
                    if (this.max != null && this.max.floatValue() < 0.0f) {
                        throw new FoggyPaleGardenConfigurationException("Surface height max is negative");
                    }
                }

                @Generated
                SurfaceHeight(Float min, Float max) {
                    this.min = min;
                    this.max = max;
                }

                @Generated
                public static SurfaceHeightBuilder builder() {
                    return new SurfaceHeightBuilder();
                }

                @Generated
                public Float getMin() {
                    return this.min;
                }

                @Generated
                public Float getMax() {
                    return this.max;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SurfaceHeight)) {
                        return false;
                    }
                    SurfaceHeight other = (SurfaceHeight)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Float this$min = this.getMin();
                    Float other$min = other.getMin();
                    if (this$min == null ? other$min != null : !((Object)this$min).equals(other$min)) {
                        return false;
                    }
                    Float this$max = this.getMax();
                    Float other$max = other.getMax();
                    return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SurfaceHeight;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Float $min = this.getMin();
                    result = result * 59 + ($min == null ? 43 : ((Object)$min).hashCode());
                    Float $max = this.getMax();
                    result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.SurfaceHeight(min=" + this.getMin() + ", max=" + this.getMax() + ")";
                }

                @Generated
                public static class SurfaceHeightBuilder {
                    @Generated
                    private Float min;
                    @Generated
                    private Float max;

                    @Generated
                    SurfaceHeightBuilder() {
                    }

                    @Generated
                    public SurfaceHeightBuilder min(Float min) {
                        this.min = min;
                        return this;
                    }

                    @Generated
                    public SurfaceHeightBuilder max(Float max) {
                        this.max = max;
                        return this;
                    }

                    @Generated
                    public SurfaceHeight build() {
                        return new SurfaceHeight(this.min, this.max);
                    }

                    @Generated
                    public String toString() {
                        return "FogPresetV3.Binding.Condition.SurfaceHeight.SurfaceHeightBuilder(min=" + this.min + ", max=" + this.max + ")";
                    }
                }
            }

            @Generated
            public static class ConditionBuilder {
                @Generated
                private Set<String> dimensionIn;
                @Generated
                private Set<String> biomeIdIn;
                @Generated
                private Temperature biomeTemperature;
                @Generated
                private Set<Difficulty> difficultyIn;
                @Generated
                private Set<Weather> weatherIn;
                @Generated
                private TimePeriod timeIn;
                @Generated
                private SkyLightLevel skyLightLevel;
                @Generated
                private Height height;
                @Generated
                private SurfaceHeight surfaceHeight;
                @Generated
                private List<Condition> and;
                @Generated
                private List<Condition> or;
                @Generated
                private Condition not;

                @Generated
                ConditionBuilder() {
                }

                @Generated
                public ConditionBuilder dimensionIn(Set<String> dimensionIn) {
                    this.dimensionIn = dimensionIn;
                    return this;
                }

                @Generated
                public ConditionBuilder biomeIdIn(Set<String> biomeIdIn) {
                    this.biomeIdIn = biomeIdIn;
                    return this;
                }

                @Generated
                public ConditionBuilder biomeTemperature(Temperature biomeTemperature) {
                    this.biomeTemperature = biomeTemperature;
                    return this;
                }

                @Generated
                public ConditionBuilder difficultyIn(Set<Difficulty> difficultyIn) {
                    this.difficultyIn = difficultyIn;
                    return this;
                }

                @Generated
                public ConditionBuilder weatherIn(Set<Weather> weatherIn) {
                    this.weatherIn = weatherIn;
                    return this;
                }

                @Generated
                public ConditionBuilder timeIn(TimePeriod timeIn) {
                    this.timeIn = timeIn;
                    return this;
                }

                @Generated
                public ConditionBuilder skyLightLevel(SkyLightLevel skyLightLevel) {
                    this.skyLightLevel = skyLightLevel;
                    return this;
                }

                @Generated
                public ConditionBuilder height(Height height) {
                    this.height = height;
                    return this;
                }

                @Generated
                public ConditionBuilder surfaceHeight(SurfaceHeight surfaceHeight) {
                    this.surfaceHeight = surfaceHeight;
                    return this;
                }

                @Generated
                public ConditionBuilder and(List<Condition> and) {
                    this.and = and;
                    return this;
                }

                @Generated
                public ConditionBuilder or(List<Condition> or) {
                    this.or = or;
                    return this;
                }

                @Generated
                public ConditionBuilder not(Condition not) {
                    this.not = not;
                    return this;
                }

                @Generated
                public Condition build() {
                    return new Condition(this.dimensionIn, this.biomeIdIn, this.biomeTemperature, this.difficultyIn, this.weatherIn, this.timeIn, this.skyLightLevel, this.height, this.surfaceHeight, this.and, this.or, this.not);
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Condition.ConditionBuilder(dimensionIn=" + String.valueOf(this.dimensionIn) + ", biomeIdIn=" + String.valueOf(this.biomeIdIn) + ", biomeTemperature=" + String.valueOf(this.biomeTemperature) + ", difficultyIn=" + String.valueOf(this.difficultyIn) + ", weatherIn=" + String.valueOf(this.weatherIn) + ", timeIn=" + String.valueOf(this.timeIn) + ", skyLightLevel=" + String.valueOf(this.skyLightLevel) + ", height=" + String.valueOf(this.height) + ", surfaceHeight=" + String.valueOf(this.surfaceHeight) + ", and=" + String.valueOf(this.and) + ", or=" + String.valueOf(this.or) + ", not=" + String.valueOf(this.not) + ")";
                }
            }

            public static enum Weather {
                CLEAR,
                RAIN,
                THUNDER;

            }
        }

        public static class Brightness {
            private final BrightnessMode mode;
            private final Float fixedBrightness;
            private final Float adjustment;

            public BrightnessMode mode() {
                return this.mode;
            }

            public Float fixedBrightness() {
                return this.fixedBrightness;
            }

            public Float adjustment() {
                return this.adjustment;
            }

            public void validate() {
                if (this.mode == BrightnessMode.FIXED && (this.fixedBrightness == null || this.fixedBrightness.floatValue() < 0.0f || this.fixedBrightness.floatValue() > 100.0f)) {
                    throw new FoggyPaleGardenConfigurationException("Binding brightness fixedBrightness is not defined or out of range [0.0, 1.0]");
                }
                if (this.mode == BrightnessMode.BY_GAME_FOG && this.adjustment != null && (this.adjustment.floatValue() < -1.0f || this.adjustment.floatValue() > 1.0f)) {
                    throw new FoggyPaleGardenConfigurationException("Binding brightness adjustment is out of range [-1.0, 1.0]");
                }
            }

            @Generated
            Brightness(BrightnessMode mode, Float fixedBrightness, Float adjustment) {
                this.mode = mode;
                this.fixedBrightness = fixedBrightness;
                this.adjustment = adjustment;
            }

            @Generated
            public static BrightnessBuilder builder() {
                return new BrightnessBuilder();
            }

            @Generated
            public BrightnessMode getMode() {
                return this.mode;
            }

            @Generated
            public Float getFixedBrightness() {
                return this.fixedBrightness;
            }

            @Generated
            public Float getAdjustment() {
                return this.adjustment;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Brightness)) {
                    return false;
                }
                Brightness other = (Brightness)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Float this$fixedBrightness = this.getFixedBrightness();
                Float other$fixedBrightness = other.getFixedBrightness();
                if (this$fixedBrightness == null ? other$fixedBrightness != null : !((Object)this$fixedBrightness).equals(other$fixedBrightness)) {
                    return false;
                }
                Float this$adjustment = this.getAdjustment();
                Float other$adjustment = other.getAdjustment();
                if (this$adjustment == null ? other$adjustment != null : !((Object)this$adjustment).equals(other$adjustment)) {
                    return false;
                }
                BrightnessMode this$mode = this.getMode();
                BrightnessMode other$mode = other.getMode();
                return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Brightness;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Float $fixedBrightness = this.getFixedBrightness();
                result = result * 59 + ($fixedBrightness == null ? 43 : ((Object)$fixedBrightness).hashCode());
                Float $adjustment = this.getAdjustment();
                result = result * 59 + ($adjustment == null ? 43 : ((Object)$adjustment).hashCode());
                BrightnessMode $mode = this.getMode();
                result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "FogPresetV3.Binding.Brightness(mode=" + String.valueOf((Object)this.getMode()) + ", fixedBrightness=" + this.getFixedBrightness() + ", adjustment=" + this.getAdjustment() + ")";
            }

            public static enum BrightnessMode {
                FIXED,
                BY_GAME_FOG;

            }

            @Generated
            public static class BrightnessBuilder {
                @Generated
                private BrightnessMode mode;
                @Generated
                private Float fixedBrightness;
                @Generated
                private Float adjustment;

                @Generated
                BrightnessBuilder() {
                }

                @Generated
                public BrightnessBuilder mode(BrightnessMode mode) {
                    this.mode = mode;
                    return this;
                }

                @Generated
                public BrightnessBuilder fixedBrightness(Float fixedBrightness) {
                    this.fixedBrightness = fixedBrightness;
                    return this;
                }

                @Generated
                public BrightnessBuilder adjustment(Float adjustment) {
                    this.adjustment = adjustment;
                    return this;
                }

                @Generated
                public Brightness build() {
                    return new Brightness(this.mode, this.fixedBrightness, this.adjustment);
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Brightness.BrightnessBuilder(mode=" + String.valueOf((Object)this.mode) + ", fixedBrightness=" + this.fixedBrightness + ", adjustment=" + this.adjustment + ")";
                }
            }
        }

        public static class Color {
            private static final Pattern HEX_PATTERN = Pattern.compile("^[0-9a-fA-F]{6}$");
            private final ColorMode mode;
            private final String fixedHex;

            public ColorMode mode() {
                return this.mode;
            }

            public String fixedHex() {
                return this.fixedHex;
            }

            public void validate() {
                if (this.mode == ColorMode.FIXED && (this.fixedHex == null || this.fixedHex.trim().isEmpty() || !HEX_PATTERN.matcher(this.fixedHex).matches())) {
                    throw new FoggyPaleGardenConfigurationException("Binding fixedHex is not defined or invalid");
                }
            }

            @Generated
            Color(ColorMode mode, String fixedHex) {
                this.mode = mode;
                this.fixedHex = fixedHex;
            }

            @Generated
            public static ColorBuilder builder() {
                return new ColorBuilder();
            }

            @Generated
            public ColorMode getMode() {
                return this.mode;
            }

            @Generated
            public String getFixedHex() {
                return this.fixedHex;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Color)) {
                    return false;
                }
                Color other = (Color)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ColorMode this$mode = this.getMode();
                ColorMode other$mode = other.getMode();
                if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
                    return false;
                }
                String this$fixedHex = this.getFixedHex();
                String other$fixedHex = other.getFixedHex();
                return !(this$fixedHex == null ? other$fixedHex != null : !this$fixedHex.equals(other$fixedHex));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Color;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ColorMode $mode = this.getMode();
                result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
                String $fixedHex = this.getFixedHex();
                result = result * 59 + ($fixedHex == null ? 43 : $fixedHex.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "FogPresetV3.Binding.Color(mode=" + String.valueOf((Object)this.getMode()) + ", fixedHex=" + this.getFixedHex() + ")";
            }

            public static enum ColorMode {
                FIXED,
                BY_GAME_FOG;

            }

            @Generated
            public static class ColorBuilder {
                @Generated
                private ColorMode mode;
                @Generated
                private String fixedHex;

                @Generated
                ColorBuilder() {
                }

                @Generated
                public ColorBuilder mode(ColorMode mode) {
                    this.mode = mode;
                    return this;
                }

                @Generated
                public ColorBuilder fixedHex(String fixedHex) {
                    this.fixedHex = fixedHex;
                    return this;
                }

                @Generated
                public Color build() {
                    return new Color(this.mode, this.fixedHex);
                }

                @Generated
                public String toString() {
                    return "FogPresetV3.Binding.Color.ColorBuilder(mode=" + String.valueOf((Object)this.mode) + ", fixedHex=" + this.fixedHex + ")";
                }
            }
        }

        @Generated
        public static class BindingBuilder {
            @Generated
            private Condition condition;
            @Generated
            private Float startDistance;
            @Generated
            private Float endDistance;
            @Generated
            private Float opacity;
            @Generated
            private Float encapsulationSpeed;
            @Generated
            private Brightness brightness;
            @Generated
            private Color color;
            @Generated
            private FogShape shape;

            @Generated
            BindingBuilder() {
            }

            @Generated
            public BindingBuilder condition(Condition condition) {
                this.condition = condition;
                return this;
            }

            @Generated
            public BindingBuilder startDistance(Float startDistance) {
                this.startDistance = startDistance;
                return this;
            }

            @Generated
            public BindingBuilder endDistance(Float endDistance) {
                this.endDistance = endDistance;
                return this;
            }

            @Generated
            public BindingBuilder opacity(Float opacity) {
                this.opacity = opacity;
                return this;
            }

            @Generated
            public BindingBuilder encapsulationSpeed(Float encapsulationSpeed) {
                this.encapsulationSpeed = encapsulationSpeed;
                return this;
            }

            @Generated
            public BindingBuilder brightness(Brightness brightness) {
                this.brightness = brightness;
                return this;
            }

            @Generated
            public BindingBuilder color(Color color) {
                this.color = color;
                return this;
            }

            @Generated
            public BindingBuilder shape(FogShape shape) {
                this.shape = shape;
                return this;
            }

            @Generated
            public Binding build() {
                return new Binding(this.condition, this.startDistance, this.endDistance, this.opacity, this.encapsulationSpeed, this.brightness, this.color, this.shape);
            }

            @Generated
            public String toString() {
                return "FogPresetV3.Binding.BindingBuilder(condition=" + String.valueOf(this.condition) + ", startDistance=" + this.startDistance + ", endDistance=" + this.endDistance + ", opacity=" + this.opacity + ", encapsulationSpeed=" + this.encapsulationSpeed + ", brightness=" + String.valueOf(this.brightness) + ", color=" + String.valueOf(this.color) + ", shape=" + String.valueOf((Object)this.shape) + ")";
            }
        }
    }

    @Generated
    public static abstract class FogPresetV3Builder<C extends FogPresetV3, B extends FogPresetV3Builder<C, B>>
    extends FogPreset.FogPresetBuilder<C, B> {
        @Generated
        private List<Binding> bindings;

        @Generated
        public B bindings(@NotNull List<Binding> bindings) {
            if (bindings == null) {
                throw new NullPointerException("bindings is marked non-null but is null");
            }
            this.bindings = bindings;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FogPresetV3.FogPresetV3Builder(super=" + super.toString() + ", bindings=" + String.valueOf(this.bindings) + ")";
        }
    }

    @Generated
    private static final class FogPresetV3BuilderImpl
    extends FogPresetV3Builder<FogPresetV3, FogPresetV3BuilderImpl> {
        @Generated
        private FogPresetV3BuilderImpl() {
        }

        @Override
        @Generated
        protected FogPresetV3BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FogPresetV3 build() {
            return new FogPresetV3(this);
        }
    }
}

