/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.config.presetsource;

import com.naocraftlab.foggypalegarden.FoggyPaleGarden;
import com.naocraftlab.foggypalegarden.config.preset.FogPreset;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSource;
import com.naocraftlab.foggypalegarden.exception.FoggyPaleGardenEnvironmentException;
import com.naocraftlab.foggypalegarden.util.FpgFiles;
import com.naocraftlab.foggypalegarden.util.Pair;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public final class PresetSourceConfig<T extends FogPreset>
implements PresetSource<T> {
    public static final Path PRESET_DIR_PATH = FoggyPaleGarden.CONFIG_DIR.resolve("foggypalegarden");
    private final int presetVersion;
    private final Class<T> presetType;

    @Override
    public PresetSource.PresetSourceType type() {
        return PresetSource.PresetSourceType.CONFIG;
    }

    @Override
    public List<PresetSource.PresetBox<T>> load() {
        if (Files.exists(PRESET_DIR_PATH, new LinkOption[0])) {
            List<PresetSource.PresetBox<T>> list;
            block9: {
                Stream<Path> stream = Files.list(PRESET_DIR_PATH);
                try {
                    list = stream.filter(file -> Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".json")).map(path -> new Pair<Path, FogPreset>((Path)path, (FogPreset)FoggyPaleGarden.GSON.fromJson(FpgFiles.readString(path), FogPreset.class))).filter(pair -> ((FogPreset)pair.second()).getVersion() == this.presetVersion).map(pair -> new Pair<Path, FogPreset>((Path)pair.first(), (FogPreset)FoggyPaleGarden.GSON.fromJson(FpgFiles.readString((Path)pair.first()), this.presetType))).map(pair -> PresetSource.PresetBox.builder().sourceType(this.type()).code(((FogPreset)pair.second()).getCode()).path(((Path)pair.first()).toString()).preset((FogPreset)pair.second()).build()).toList();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new FoggyPaleGardenEnvironmentException("Failed to read presets", e);
                    }
                }
                stream.close();
            }
            return list;
        }
        FpgFiles.createDirectories(PRESET_DIR_PATH);
        return List.of();
    }

    @Override
    public void save(Collection<PresetSource.PresetBox<T>> presets) {
        for (PresetSource.PresetBox<T> presetBox : presets) {
            if (presetBox.getSourceType() != PresetSource.PresetSourceType.CONFIG) continue;
            FpgFiles.writeString(PRESET_DIR_PATH.resolve(presetBox.getCode() + ".json"), FoggyPaleGarden.GSON.toJson(presetBox.getPreset()));
        }
    }

    @Generated
    public PresetSourceConfig(int presetVersion, Class<T> presetType) {
        this.presetVersion = presetVersion;
        this.presetType = presetType;
    }
}

