/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.config.presetsource;

import com.naocraftlab.foggypalegarden.FoggyPaleGarden;
import com.naocraftlab.foggypalegarden.config.preset.FogPreset;
import com.naocraftlab.foggypalegarden.config.presetsource.PresetSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class PresetSourceResourcePack<T extends FogPreset>
implements PresetSource<T> {
    private static final String PRESET_RESOURCE_NAME = "preset.json";
    private final int presetVersion;
    private final Class<T> presetType;

    @Override
    public PresetSource.PresetSourceType type() {
        return PresetSource.PresetSourceType.RESOURCE_PACK;
    }

    @Override
    public List<PresetSource.PresetBox<T>> load() {
        ArrayList<PresetSource.PresetBox<T>> presetBoxes = new ArrayList<PresetSource.PresetBox<T>>();
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        List resources = resourceManager.getResourceStack(ResourceLocation.tryBuild((String)"foggypalegarden", (String)PRESET_RESOURCE_NAME));
        for (Resource resource : resources) {
            try {
                InputStream stream = resource.open();
                try {
                    String json = new String(stream.readAllBytes());
                    FogPreset preset = (FogPreset)FoggyPaleGarden.GSON.fromJson(json, FogPreset.class);
                    if (preset.getVersion() != this.presetVersion) continue;
                    FogPreset presetV3 = (FogPreset)FoggyPaleGarden.GSON.fromJson(json, this.presetType);
                    PackResources source = resource.source();
                    try {
                        PresetSource.PresetBox<FogPreset> presetBox = PresetSource.PresetBox.builder().sourceType(this.type()).code(presetV3.getCode()).path(source.packId().replaceAll("^file/", "") + ":assets/foggypalegarden/preset.json").preset(presetV3).build();
                        presetBoxes.add(presetBox);
                    }
                    finally {
                        if (source == null) continue;
                        source.close();
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return presetBoxes;
    }

    @Override
    public void save(Collection<PresetSource.PresetBox<T>> presets) {
    }

    @Generated
    public PresetSourceResourcePack(int presetVersion, Class<T> presetType) {
        this.presetVersion = presetVersion;
        this.presetType = presetType;
    }
}

