/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.domain.service;

import com.naocraftlab.foggypalegarden.config.preset.FogPresetV3;
import com.naocraftlab.foggypalegarden.domain.model.Color;
import com.naocraftlab.foggypalegarden.domain.model.Environment;
import com.naocraftlab.foggypalegarden.domain.model.FogCharacteristics;
import com.naocraftlab.foggypalegarden.domain.model.FogMode;
import com.naocraftlab.foggypalegarden.domain.model.FogShape;
import com.naocraftlab.foggypalegarden.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public final class FogService {
    private static List<Pair<Predicate<Environment>, FogPresetV3.Binding>> presetBindings = List.of();
    private static FogPresetV3.Binding latestFogBinding;
    private static FogPresetV3.Binding newFogBinding;
    private static boolean canApplyFog;
    private static float fogDensity;

    public static void onCurrentPresetChange(FogPresetV3 currentPreset) {
        presetBindings = currentPreset.getBindings().stream().map(binding -> new Pair<Predicate<Environment>, FogPresetV3.Binding>(binding.condition().toPredicate(), (FogPresetV3.Binding)binding)).toList();
    }

    public static void changeFogBinding(Environment environment) {
        if (newFogBinding != null) {
            latestFogBinding = newFogBinding;
        }
        if (canApplyFog = environment.canApplyFog()) {
            newFogBinding = presetBindings.stream().filter(pair -> ((Predicate)pair.first()).test(environment)).map(Pair::second).findFirst().orElse(null);
        }
    }

    public static Color calculateFogColor(Color gameFogColor) {
        float blue;
        float green;
        float red;
        if (!canApplyFog) {
            return gameFogColor;
        }
        FogPresetV3.Binding targetBinding = FogService.targetBinding();
        if (targetBinding == null) {
            return gameFogColor;
        }
        FogPresetV3.Binding.Brightness.BrightnessMode brightnessMode = targetBinding.brightness().mode();
        FogPresetV3.Binding.Color.ColorMode colorMode = targetBinding.color().mode();
        if (brightnessMode == FogPresetV3.Binding.Brightness.BrightnessMode.FIXED && colorMode == FogPresetV3.Binding.Color.ColorMode.FIXED) {
            float brightness = targetBinding.brightness().fixedBrightness().floatValue() / 100.0f;
            red = Math.min(FogService.hexToRed(targetBinding.color().fixedHex()) * brightness, 1.0f);
            green = Math.min(FogService.hexToGreen(targetBinding.color().fixedHex()) * brightness, 1.0f);
            blue = Math.min(FogService.hexToBlue(targetBinding.color().fixedHex()) * brightness, 1.0f);
        } else if (brightnessMode == FogPresetV3.Binding.Brightness.BrightnessMode.BY_GAME_FOG && colorMode == FogPresetV3.Binding.Color.ColorMode.FIXED) {
            float brightness = FogService.calculateBrightness(gameFogColor);
            red = Math.min(FogService.hexToRed(targetBinding.color().fixedHex()) * brightness, 1.0f);
            green = Math.min(FogService.hexToGreen(targetBinding.color().fixedHex()) * brightness, 1.0f);
            blue = Math.min(FogService.hexToBlue(targetBinding.color().fixedHex()) * brightness, 1.0f);
            if (targetBinding.brightness().adjustment() != null) {
                float adjustment = targetBinding.brightness().adjustment().floatValue();
                red = adjustment >= 0.0f ? (red += adjustment * (1.0f - red)) : (red += adjustment * red);
                red = Math.max(0.0f, Math.min(red, 1.0f));
                green = adjustment >= 0.0f ? (green += adjustment * (1.0f - green)) : (green += adjustment * green);
                green = Math.max(0.0f, Math.min(green, 1.0f));
                blue = adjustment >= 0.0f ? (blue += adjustment * (1.0f - blue)) : (blue += adjustment * blue);
                blue = Math.max(0.0f, Math.min(blue, 1.0f));
            }
        } else if (brightnessMode == FogPresetV3.Binding.Brightness.BrightnessMode.FIXED && colorMode == FogPresetV3.Binding.Color.ColorMode.BY_GAME_FOG) {
            float targetBrightness = targetBinding.brightness().fixedBrightness().floatValue() / 100.0f;
            float currentBrightness = FogService.calculateBrightness(gameFogColor);
            float scale = targetBrightness / currentBrightness;
            red = Math.min(gameFogColor.red() * scale, 1.0f);
            green = Math.min(gameFogColor.green() * scale, 1.0f);
            blue = Math.min(gameFogColor.blue() * scale, 1.0f);
        } else {
            red = gameFogColor.red();
            green = gameFogColor.green();
            blue = gameFogColor.blue();
            if (targetBinding.brightness().adjustment() != null) {
                float adjustment = targetBinding.brightness().adjustment().floatValue();
                red = adjustment >= 0.0f ? (red += adjustment * (1.0f - red)) : (red += adjustment * red);
                red = Math.max(0.0f, Math.min(red, 1.0f));
                green = adjustment >= 0.0f ? (green += adjustment * (1.0f - green)) : (green += adjustment * green);
                green = Math.max(0.0f, Math.min(green, 1.0f));
                blue = adjustment >= 0.0f ? (blue += adjustment * (1.0f - blue)) : (blue += adjustment * blue);
                blue = Math.max(0.0f, Math.min(blue, 1.0f));
            }
        }
        return Color.builder().red(FogService.clamp(gameFogColor.red(), red, fogDensity)).green(FogService.clamp(gameFogColor.green(), green, fogDensity)).blue(FogService.clamp(gameFogColor.blue(), blue, fogDensity)).alpha(FogService.clamp(1.0f, targetBinding.opacity().floatValue() / 100.0f, fogDensity)).build();
    }

    @Nullable
    public static FogCharacteristics calculateFogCharacteristics(FogMode fogMode, float originalStart, float originalEnd) {
        FogShape shape;
        float endDistance;
        float startDistance;
        if (!canApplyFog) {
            return null;
        }
        FogPresetV3.Binding targetBinding = FogService.targetBinding();
        if (targetBinding == null) {
            return null;
        }
        float f = fogDensity = newFogBinding != null ? Math.min(fogDensity + targetBinding.encapsulationSpeed().floatValue() / 100.0f / 20.0f, 1.0f) : Math.max(fogDensity - targetBinding.encapsulationSpeed().floatValue() / 100.0f / 20.0f, 0.0f);
        if (fogMode == FogMode.FOG_SKY) {
            startDistance = 0.0f;
            endDistance = originalEnd;
            shape = FogShape.CYLINDER;
        } else {
            startDistance = FogService.clamp(originalStart, targetBinding.startDistance().floatValue(), fogDensity);
            endDistance = FogService.clamp(originalEnd, targetBinding.endDistance().floatValue(), fogDensity);
            shape = targetBinding.shape();
        }
        return FogCharacteristics.builder().startDistance(startDistance).endDistance(endDistance).shape(shape).build();
    }

    @Nullable
    private static FogPresetV3.Binding targetBinding() {
        if (newFogBinding != null) {
            return newFogBinding;
        }
        if (latestFogBinding != null && fogDensity > 0.0f) {
            return latestFogBinding;
        }
        return null;
    }

    private static float hexToRed(String hex) {
        return (float)Integer.parseInt(hex.substring(0, 2), 16) / 100.0f;
    }

    private static float hexToGreen(String hex) {
        return (float)Integer.parseInt(hex.substring(2, 4), 16) / 100.0f;
    }

    private static float hexToBlue(String hex) {
        return (float)Integer.parseInt(hex.substring(4, 6), 16) / 100.0f;
    }

    private static float calculateBrightness(Color color) {
        return (0.299f * color.red() + 0.587f * color.green() + 0.114f * color.blue()) * color.alpha();
    }

    private static float clamp(float source, float target, float modifier) {
        float clampedModifier = Mth.clamp((float)modifier, (float)0.0f, (float)1.0f);
        return source + (target - source) * clampedModifier;
    }

    @Generated
    private FogService() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        newFogBinding = latestFogBinding = null;
        canApplyFog = false;
        fogDensity = 0.0f;
    }
}

