/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.mixin;

import com.mojang.blaze3d.shaders.FogShape;
import com.naocraftlab.foggypalegarden.config.ConfigFacade;
import com.naocraftlab.foggypalegarden.converter.GameTypeConverter;
import com.naocraftlab.foggypalegarden.domain.model.Color;
import com.naocraftlab.foggypalegarden.domain.model.Environment;
import com.naocraftlab.foggypalegarden.domain.model.FogCharacteristics;
import com.naocraftlab.foggypalegarden.domain.model.FogMode;
import com.naocraftlab.foggypalegarden.domain.model.Weather;
import com.naocraftlab.foggypalegarden.domain.service.FogService;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogParameters;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FogRenderer.class})
public abstract class PaleGardenFogMixin {
    @Shadow
    private static boolean fogEnabled;

    @Inject(method={"computeFogColor(Lnet/minecraft/client/Camera;FLnet/minecraft/client/multiplayer/ClientLevel;IF)Lorg/joml/Vector4f;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectComputeFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, CallbackInfoReturnable<Vector4f> cir) {
        Vector4f gameFogColor = (Vector4f)cir.getReturnValue();
        Color newColor = FogService.calculateFogColor(PaleGardenFogMixin.toColor(gameFogColor));
        cir.setReturnValue((Object)PaleGardenFogMixin.toVector4f(newColor));
    }

    @Inject(method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;Lorg/joml/Vector4f;FZF)Lnet/minecraft/client/renderer/FogParameters;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectSetupFog(Camera camera, FogRenderer.FogMode fogMode, Vector4f fogColor, float renderDistance, boolean isFoggy, float partialTick, CallbackInfoReturnable<FogParameters> cir) {
        Entity entity = camera.getEntity();
        GameType gameMode = PaleGardenFogMixin.resolveGameMode(entity);
        FogType fogType = camera.getFluidInCamera();
        boolean canApplyFog = fogEnabled && !ConfigFacade.configFacade().isNoFogGameMode(GameTypeConverter.toDomainGameType(gameMode)) && fogType != FogType.LAVA && fogType != FogType.POWDER_SNOW && fogType != FogType.WATER && !isFoggy && !PaleGardenFogMixin.hasMobEffect(entity);
        ClientLevel world = (ClientLevel)entity.getCommandSenderWorld();
        BlockPos blockPos = camera.getBlockPosition();
        Holder biomeEntry = world.getBiome(blockPos);
        BlockHitResult hitResult = world.clip(new ClipContext(blockPos.getCenter(), blockPos.offset(0, -256, 0).getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity));
        FogService.changeFogBinding(Environment.builder().dimension(world.dimension().location().toString()).biome(biomeEntry.getRegisteredName()).biomeTemperature(Float.valueOf(((Biome)biomeEntry.value()).getBaseTemperature())).difficulty(world.getDifficulty()).weather(PaleGardenFogMixin.resolveWeather(world)).timeOfDay(world.getDayTime() % 24000L).skyLightLevel(world.getBrightness(LightLayer.SKY, blockPos)).height(blockPos.getY()).heightAboveSurface(blockPos.getY() - hitResult.getBlockPos().getY()).canApplyFog(canApplyFog).build());
        FogParameters originalFogParameters = (FogParameters)cir.getReturnValue();
        FogCharacteristics characteristics = FogService.calculateFogCharacteristics(FogMode.valueOf(fogMode.name()), originalFogParameters.start(), originalFogParameters.end());
        if (characteristics != null) {
            cir.setReturnValue((Object)PaleGardenFogMixin.fogOf(characteristics, PaleGardenFogMixin.toColor(fogColor)));
            cir.cancel();
        }
    }

    @Unique
    private static boolean hasMobEffect(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.hasEffect(MobEffects.BLINDNESS) || livingEntity.hasEffect(MobEffects.DARKNESS);
        }
        return false;
    }

    @Unique
    private static GameType resolveGameMode(Entity player) {
        if (!(player instanceof LocalPlayer)) {
            return GameType.SPECTATOR;
        }
        Abilities attributes = ((LocalPlayer)player).getAbilities();
        if (attributes.instabuild) {
            return GameType.CREATIVE;
        }
        if (attributes.mayfly && attributes.invulnerable && attributes.flying) {
            return GameType.SPECTATOR;
        }
        if (attributes.mayBuild) {
            return GameType.SURVIVAL;
        }
        return GameType.ADVENTURE;
    }

    @Unique
    private static Weather resolveWeather(ClientLevel world) {
        if (world.isThundering()) {
            return Weather.THUNDER;
        }
        if (world.isRaining()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    @Unique
    private static Color toColor(Vector4f color) {
        return Color.builder().red(color.x).green(color.y).blue(color.z).alpha(color.w).build();
    }

    @Unique
    private static Vector4f toVector4f(Color color) {
        return new Vector4f(color.red(), color.green(), color.blue(), color.alpha());
    }

    @Unique
    private static FogParameters fogOf(FogCharacteristics fogCharacteristics, Color fogColor) {
        return new FogParameters(fogCharacteristics.startDistance(), fogCharacteristics.endDistance(), FogShape.valueOf((String)fogCharacteristics.shape().name()), fogColor.red(), fogColor.green(), fogColor.blue(), fogColor.alpha());
    }
}

