/*
 * Decompiled with CFR 0.152.
 */
package com.naocraftlab.foggypalegarden.util;

import com.naocraftlab.foggypalegarden.exception.FoggyPaleGardenEnvironmentException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class FpgFiles {
    @NotNull
    public static String readString(@NotNull Path path) {
        try {
            return Files.readString(path, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new FoggyPaleGardenEnvironmentException("Failed to read file (" + String.valueOf(path.toAbsolutePath()) + ")", e);
        }
    }

    @NotNull
    public static Path writeString(@NotNull Path path, @NotNull CharSequence charSequence) {
        try {
            FpgFiles.createDirectories(path.getParent());
            Files.writeString(path, charSequence, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            throw new FoggyPaleGardenEnvironmentException("Failed to write file (" + String.valueOf(path.toAbsolutePath()) + ")", e);
        }
        return path;
    }

    @NotNull
    public static Path move(@NotNull Path source, @NotNull Path target) {
        try {
            FpgFiles.createDirectories(target.getParent());
            return Files.move(source, target, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new FoggyPaleGardenEnvironmentException("Failed to move file (" + String.valueOf(source.toAbsolutePath()) + " -> " + String.valueOf(target.toAbsolutePath()) + ")", e);
        }
    }

    public static boolean createDirectories(@NotNull Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return false;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new FoggyPaleGardenEnvironmentException("Failed to create directory (" + String.valueOf(path.toAbsolutePath()) + ")", e);
        }
        return true;
    }

    @Generated
    private FpgFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

