/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coppertoolsexpanded.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import net.mcreator.coppertoolsexpanded.init.CopperToolsExpandedModItems;
import net.mcreator.coppertoolsexpanded.procedures.WearingCopperBootsProcedure;
import net.mcreator.coppertoolsexpanded.procedures.WearingCopperChestplateProcedure;
import net.mcreator.coppertoolsexpanded.procedures.WearingCopperHelmetProcedure;
import net.mcreator.coppertoolsexpanded.procedures.WearingCopperLeggingsProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class PolishedCopperArmorItem
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(13, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 5, ArmorType.CHESTPLATE, 6, ArmorType.HELMET, 2, ArmorType.BODY, 6), 25, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_gold")), 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"copper_tools_expanded:polished_copper_armor_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"copper_tools_expanded:polished_copper_armor")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"copper_tools_expanded:textures/models/armor/polished_copper_armor__layer_1.png");
            }
        }, new Item[]{(Item)CopperToolsExpandedModItems.POLISHED_COPPER_ARMOR_HELMET.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"copper_tools_expanded:textures/models/armor/polished_copper_armor__layer_1.png");
            }
        }, new Item[]{(Item)CopperToolsExpandedModItems.POLISHED_COPPER_ARMOR_CHESTPLATE.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"copper_tools_expanded:textures/models/armor/polished_copper_armor__layer_2.png");
            }
        }, new Item[]{(Item)CopperToolsExpandedModItems.POLISHED_COPPER_ARMOR_LEGGINGS.get()});
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"copper_tools_expanded:textures/models/armor/polished_copper_armor__layer_1.png");
            }
        }, new Item[]{(Item)CopperToolsExpandedModItems.POLISHED_COPPER_ARMOR_BOOTS.get()});
    }

    private PolishedCopperArmorItem(Item.Properties properties) {
        super(properties);
    }

    public static class Boots
    extends PolishedCopperArmorItem {
        public Boots(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.BOOTS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                WearingCopperBootsProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }

    public static class Leggings
    extends PolishedCopperArmorItem {
        public Leggings(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.LEGGINGS));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                WearingCopperLeggingsProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }

    public static class Chestplate
    extends PolishedCopperArmorItem {
        public Chestplate(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.CHESTPLATE));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                WearingCopperChestplateProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }

    public static class Helmet
    extends PolishedCopperArmorItem {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                WearingCopperHelmetProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
            }
        }
    }
}

