/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coppertoolsexpanded.network;

import java.util.function.Supplier;
import net.mcreator.coppertoolsexpanded.CopperToolsExpandedMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CopperToolsExpandedModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"copper_tools_expanded");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CopperToolsExpandedMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"copper_tools_expanded", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double lvlCurseofVanishing = 0.0;
        public double lvlUnbreaking = 0.0;
        public double lvlMending = 0.0;
        public double lvlProtection = 0.0;
        public double lvlFireProtection = 0.0;
        public double lvlBlastProtection = 0.0;
        public double lvlProjectileProtection = 0.0;
        public double lvlThorns = 0.0;
        public double lvlCurseofBinding = 0.0;
        public double lvlFeatherFalling = 0.0;
        public double lvlDepthStrider = 0.0;
        public double lvlFrostWalker = 0.0;
        public double lvlSoulSpeed = 0.0;
        public double lvlAquaAffinity = 0.0;
        public double lvlRespiration = 0.0;
        public double lvlSharpness = 0.0;
        public double lvlEfficiency = 0.0;
        public double lvlSilkTouch = 0.0;
        public double lvlFortune = 0.0;
        public double lvlSmite = 0.0;
        public double lvlBaneofArthropods = 0.0;
        public double lvlKnockback = 0.0;
        public double lvlSweepingEdge = 0.0;
        public double lvlFireAspect = 0.0;
        public double lvlLooting = 0.0;
        public double copperDurability = 0.0;
        public double lvlSwiftSneak = 0.0;

        private void putItemStack(CompoundTag nbt, String key, ItemStack stack, HolderLookup.Provider lookupProvider) {
            if (!stack.isEmpty()) {
                nbt.put(key, stack.save(lookupProvider));
            } else {
                nbt.putBoolean(key + "_empty", true);
            }
        }

        private ItemStack getItemStack(CompoundTag nbt, String key, HolderLookup.Provider lookupProvider) {
            if (nbt.contains(key + "_empty")) {
                return ItemStack.EMPTY;
            }
            return nbt.contains(key) ? ItemStack.parse((HolderLookup.Provider)lookupProvider, (Tag)nbt.getCompoundOrEmpty(key)).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("lvlCurseofVanishing", this.lvlCurseofVanishing);
            nbt.putDouble("lvlUnbreaking", this.lvlUnbreaking);
            nbt.putDouble("lvlMending", this.lvlMending);
            nbt.putDouble("lvlProtection", this.lvlProtection);
            nbt.putDouble("lvlFireProtection", this.lvlFireProtection);
            nbt.putDouble("lvlBlastProtection", this.lvlBlastProtection);
            nbt.putDouble("lvlProjectileProtection", this.lvlProjectileProtection);
            nbt.putDouble("lvlThorns", this.lvlThorns);
            nbt.putDouble("lvlCurseofBinding", this.lvlCurseofBinding);
            nbt.putDouble("lvlFeatherFalling", this.lvlFeatherFalling);
            nbt.putDouble("lvlDepthStrider", this.lvlDepthStrider);
            nbt.putDouble("lvlFrostWalker", this.lvlFrostWalker);
            nbt.putDouble("lvlSoulSpeed", this.lvlSoulSpeed);
            nbt.putDouble("lvlAquaAffinity", this.lvlAquaAffinity);
            nbt.putDouble("lvlRespiration", this.lvlRespiration);
            nbt.putDouble("lvlSharpness", this.lvlSharpness);
            nbt.putDouble("lvlEfficiency", this.lvlEfficiency);
            nbt.putDouble("lvlSilkTouch", this.lvlSilkTouch);
            nbt.putDouble("lvlFortune", this.lvlFortune);
            nbt.putDouble("lvlSmite", this.lvlSmite);
            nbt.putDouble("lvlBaneofArthropods", this.lvlBaneofArthropods);
            nbt.putDouble("lvlKnockback", this.lvlKnockback);
            nbt.putDouble("lvlSweepingEdge", this.lvlSweepingEdge);
            nbt.putDouble("lvlFireAspect", this.lvlFireAspect);
            nbt.putDouble("lvlLooting", this.lvlLooting);
            nbt.putDouble("copperDurability", this.copperDurability);
            nbt.putDouble("lvlSwiftSneak", this.lvlSwiftSneak);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.lvlCurseofVanishing = nbt.getDoubleOr("lvlCurseofVanishing", 0.0);
            this.lvlUnbreaking = nbt.getDoubleOr("lvlUnbreaking", 0.0);
            this.lvlMending = nbt.getDoubleOr("lvlMending", 0.0);
            this.lvlProtection = nbt.getDoubleOr("lvlProtection", 0.0);
            this.lvlFireProtection = nbt.getDoubleOr("lvlFireProtection", 0.0);
            this.lvlBlastProtection = nbt.getDoubleOr("lvlBlastProtection", 0.0);
            this.lvlProjectileProtection = nbt.getDoubleOr("lvlProjectileProtection", 0.0);
            this.lvlThorns = nbt.getDoubleOr("lvlThorns", 0.0);
            this.lvlCurseofBinding = nbt.getDoubleOr("lvlCurseofBinding", 0.0);
            this.lvlFeatherFalling = nbt.getDoubleOr("lvlFeatherFalling", 0.0);
            this.lvlDepthStrider = nbt.getDoubleOr("lvlDepthStrider", 0.0);
            this.lvlFrostWalker = nbt.getDoubleOr("lvlFrostWalker", 0.0);
            this.lvlSoulSpeed = nbt.getDoubleOr("lvlSoulSpeed", 0.0);
            this.lvlAquaAffinity = nbt.getDoubleOr("lvlAquaAffinity", 0.0);
            this.lvlRespiration = nbt.getDoubleOr("lvlRespiration", 0.0);
            this.lvlSharpness = nbt.getDoubleOr("lvlSharpness", 0.0);
            this.lvlEfficiency = nbt.getDoubleOr("lvlEfficiency", 0.0);
            this.lvlSilkTouch = nbt.getDoubleOr("lvlSilkTouch", 0.0);
            this.lvlFortune = nbt.getDoubleOr("lvlFortune", 0.0);
            this.lvlSmite = nbt.getDoubleOr("lvlSmite", 0.0);
            this.lvlBaneofArthropods = nbt.getDoubleOr("lvlBaneofArthropods", 0.0);
            this.lvlKnockback = nbt.getDoubleOr("lvlKnockback", 0.0);
            this.lvlSweepingEdge = nbt.getDoubleOr("lvlSweepingEdge", 0.0);
            this.lvlFireAspect = nbt.getDoubleOr("lvlFireAspect", 0.0);
            this.lvlLooting = nbt.getDoubleOr("lvlLooting", 0.0);
            this.copperDurability = nbt.getDoubleOr("copperDurability", 0.0);
            this.lvlSwiftSneak = nbt.getDoubleOr("lvlSwiftSneak", 0.0);
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.lvlCurseofVanishing = original.lvlCurseofVanishing;
            clone.lvlUnbreaking = original.lvlUnbreaking;
            clone.lvlMending = original.lvlMending;
            clone.lvlProtection = original.lvlProtection;
            clone.lvlFireProtection = original.lvlFireProtection;
            clone.lvlBlastProtection = original.lvlBlastProtection;
            clone.lvlProjectileProtection = original.lvlProjectileProtection;
            clone.lvlThorns = original.lvlThorns;
            clone.lvlCurseofBinding = original.lvlCurseofBinding;
            clone.lvlFeatherFalling = original.lvlFeatherFalling;
            clone.lvlDepthStrider = original.lvlDepthStrider;
            clone.lvlFrostWalker = original.lvlFrostWalker;
            clone.lvlSoulSpeed = original.lvlSoulSpeed;
            clone.lvlAquaAffinity = original.lvlAquaAffinity;
            clone.lvlRespiration = original.lvlRespiration;
            clone.lvlSharpness = original.lvlSharpness;
            clone.lvlEfficiency = original.lvlEfficiency;
            clone.lvlSilkTouch = original.lvlSilkTouch;
            clone.lvlFortune = original.lvlFortune;
            clone.lvlSmite = original.lvlSmite;
            clone.lvlBaneofArthropods = original.lvlBaneofArthropods;
            clone.lvlKnockback = original.lvlKnockback;
            clone.lvlSweepingEdge = original.lvlSweepingEdge;
            clone.lvlFireAspect = original.lvlFireAspect;
            clone.lvlLooting = original.lvlLooting;
            clone.copperDurability = original.copperDurability;
            clone.lvlSwiftSneak = original.lvlSwiftSneak;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

