/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coppertoolsexpanded.network;

import java.util.function.Supplier;
import net.mcreator.coppertoolsexpanded.CopperToolsExpandedMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class CopperToolsExpandedModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"copper_tools_expanded");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CopperToolsExpandedMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"copper_tools_expanded", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        public double lvlCurseofVanishing = 0.0;
        public double lvlUnbreaking = 0.0;
        public double lvlMending = 0.0;
        public double lvlProtection = 0.0;
        public double lvlFireProtection = 0.0;
        public double lvlBlastProtection = 0.0;
        public double lvlProjectileProtection = 0.0;
        public double lvlThorns = 0.0;
        public double lvlCurseofBinding = 0.0;
        public double lvlFeatherFalling = 0.0;
        public double lvlDepthStrider = 0.0;
        public double lvlFrostWalker = 0.0;
        public double lvlSoulSpeed = 0.0;
        public double lvlAquaAffinity = 0.0;
        public double lvlRespiration = 0.0;
        public double lvlSharpness = 0.0;
        public double lvlEfficiency = 0.0;
        public double lvlSilkTouch = 0.0;
        public double lvlFortune = 0.0;
        public double lvlSmite = 0.0;
        public double lvlBaneofArthropods = 0.0;
        public double lvlKnockback = 0.0;
        public double lvlSweepingEdge = 0.0;
        public double lvlFireAspect = 0.0;
        public double lvlLooting = 0.0;
        public double copperDurability = 0.0;
        public double lvlSwiftSneak = 0.0;

        public void serialize(ValueOutput output) {
            output.putDouble("lvlCurseofVanishing", this.lvlCurseofVanishing);
            output.putDouble("lvlUnbreaking", this.lvlUnbreaking);
            output.putDouble("lvlMending", this.lvlMending);
            output.putDouble("lvlProtection", this.lvlProtection);
            output.putDouble("lvlFireProtection", this.lvlFireProtection);
            output.putDouble("lvlBlastProtection", this.lvlBlastProtection);
            output.putDouble("lvlProjectileProtection", this.lvlProjectileProtection);
            output.putDouble("lvlThorns", this.lvlThorns);
            output.putDouble("lvlCurseofBinding", this.lvlCurseofBinding);
            output.putDouble("lvlFeatherFalling", this.lvlFeatherFalling);
            output.putDouble("lvlDepthStrider", this.lvlDepthStrider);
            output.putDouble("lvlFrostWalker", this.lvlFrostWalker);
            output.putDouble("lvlSoulSpeed", this.lvlSoulSpeed);
            output.putDouble("lvlAquaAffinity", this.lvlAquaAffinity);
            output.putDouble("lvlRespiration", this.lvlRespiration);
            output.putDouble("lvlSharpness", this.lvlSharpness);
            output.putDouble("lvlEfficiency", this.lvlEfficiency);
            output.putDouble("lvlSilkTouch", this.lvlSilkTouch);
            output.putDouble("lvlFortune", this.lvlFortune);
            output.putDouble("lvlSmite", this.lvlSmite);
            output.putDouble("lvlBaneofArthropods", this.lvlBaneofArthropods);
            output.putDouble("lvlKnockback", this.lvlKnockback);
            output.putDouble("lvlSweepingEdge", this.lvlSweepingEdge);
            output.putDouble("lvlFireAspect", this.lvlFireAspect);
            output.putDouble("lvlLooting", this.lvlLooting);
            output.putDouble("copperDurability", this.copperDurability);
            output.putDouble("lvlSwiftSneak", this.lvlSwiftSneak);
        }

        public void deserialize(ValueInput input) {
            this.lvlCurseofVanishing = input.getDoubleOr("lvlCurseofVanishing", 0.0);
            this.lvlUnbreaking = input.getDoubleOr("lvlUnbreaking", 0.0);
            this.lvlMending = input.getDoubleOr("lvlMending", 0.0);
            this.lvlProtection = input.getDoubleOr("lvlProtection", 0.0);
            this.lvlFireProtection = input.getDoubleOr("lvlFireProtection", 0.0);
            this.lvlBlastProtection = input.getDoubleOr("lvlBlastProtection", 0.0);
            this.lvlProjectileProtection = input.getDoubleOr("lvlProjectileProtection", 0.0);
            this.lvlThorns = input.getDoubleOr("lvlThorns", 0.0);
            this.lvlCurseofBinding = input.getDoubleOr("lvlCurseofBinding", 0.0);
            this.lvlFeatherFalling = input.getDoubleOr("lvlFeatherFalling", 0.0);
            this.lvlDepthStrider = input.getDoubleOr("lvlDepthStrider", 0.0);
            this.lvlFrostWalker = input.getDoubleOr("lvlFrostWalker", 0.0);
            this.lvlSoulSpeed = input.getDoubleOr("lvlSoulSpeed", 0.0);
            this.lvlAquaAffinity = input.getDoubleOr("lvlAquaAffinity", 0.0);
            this.lvlRespiration = input.getDoubleOr("lvlRespiration", 0.0);
            this.lvlSharpness = input.getDoubleOr("lvlSharpness", 0.0);
            this.lvlEfficiency = input.getDoubleOr("lvlEfficiency", 0.0);
            this.lvlSilkTouch = input.getDoubleOr("lvlSilkTouch", 0.0);
            this.lvlFortune = input.getDoubleOr("lvlFortune", 0.0);
            this.lvlSmite = input.getDoubleOr("lvlSmite", 0.0);
            this.lvlBaneofArthropods = input.getDoubleOr("lvlBaneofArthropods", 0.0);
            this.lvlKnockback = input.getDoubleOr("lvlKnockback", 0.0);
            this.lvlSweepingEdge = input.getDoubleOr("lvlSweepingEdge", 0.0);
            this.lvlFireAspect = input.getDoubleOr("lvlFireAspect", 0.0);
            this.lvlLooting = input.getDoubleOr("lvlLooting", 0.0);
            this.copperDurability = input.getDoubleOr("copperDurability", 0.0);
            this.lvlSwiftSneak = input.getDoubleOr("lvlSwiftSneak", 0.0);
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.lvlCurseofVanishing = original.lvlCurseofVanishing;
            clone.lvlUnbreaking = original.lvlUnbreaking;
            clone.lvlMending = original.lvlMending;
            clone.lvlProtection = original.lvlProtection;
            clone.lvlFireProtection = original.lvlFireProtection;
            clone.lvlBlastProtection = original.lvlBlastProtection;
            clone.lvlProjectileProtection = original.lvlProjectileProtection;
            clone.lvlThorns = original.lvlThorns;
            clone.lvlCurseofBinding = original.lvlCurseofBinding;
            clone.lvlFeatherFalling = original.lvlFeatherFalling;
            clone.lvlDepthStrider = original.lvlDepthStrider;
            clone.lvlFrostWalker = original.lvlFrostWalker;
            clone.lvlSoulSpeed = original.lvlSoulSpeed;
            clone.lvlAquaAffinity = original.lvlAquaAffinity;
            clone.lvlRespiration = original.lvlRespiration;
            clone.lvlSharpness = original.lvlSharpness;
            clone.lvlEfficiency = original.lvlEfficiency;
            clone.lvlSilkTouch = original.lvlSilkTouch;
            clone.lvlFortune = original.lvlFortune;
            clone.lvlSmite = original.lvlSmite;
            clone.lvlBaneofArthropods = original.lvlBaneofArthropods;
            clone.lvlKnockback = original.lvlKnockback;
            clone.lvlSweepingEdge = original.lvlSweepingEdge;
            clone.lvlFireAspect = original.lvlFireAspect;
            clone.lvlLooting = original.lvlLooting;
            clone.copperDurability = original.copperDurability;
            clone.lvlSwiftSneak = original.lvlSwiftSneak;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

