/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.coppertoolsexpanded.network;

import java.util.function.Supplier;
import net.mcreator.coppertoolsexpanded.CopperToolsExpandedMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CopperToolsExpandedModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CopperToolsExpandedMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.lvlCurseofVanishing = message.data.lvlCurseofVanishing;
                    variables.lvlUnbreaking = message.data.lvlUnbreaking;
                    variables.lvlMending = message.data.lvlMending;
                    variables.lvlProtection = message.data.lvlProtection;
                    variables.lvlFireProtection = message.data.lvlFireProtection;
                    variables.lvlBlastProtection = message.data.lvlBlastProtection;
                    variables.lvlProjectileProtection = message.data.lvlProjectileProtection;
                    variables.lvlThorns = message.data.lvlThorns;
                    variables.lvlCurseofBinding = message.data.lvlCurseofBinding;
                    variables.lvlFeatherFalling = message.data.lvlFeatherFalling;
                    variables.lvlDepthStrider = message.data.lvlDepthStrider;
                    variables.lvlFrostWalker = message.data.lvlFrostWalker;
                    variables.lvlSoulSpeed = message.data.lvlSoulSpeed;
                    variables.lvlAquaAffinity = message.data.lvlAquaAffinity;
                    variables.lvlRespiration = message.data.lvlRespiration;
                    variables.lvlSharpness = message.data.lvlSharpness;
                    variables.lvlEfficiency = message.data.lvlEfficiency;
                    variables.lvlSilkTouch = message.data.lvlSilkTouch;
                    variables.lvlFortune = message.data.lvlFortune;
                    variables.lvlSmite = message.data.lvlSmite;
                    variables.lvlBaneofArthropods = message.data.lvlBaneofArthropods;
                    variables.lvlKnockback = message.data.lvlKnockback;
                    variables.lvlSweepingEdge = message.data.lvlSweepingEdge;
                    variables.lvlFireAspect = message.data.lvlFireAspect;
                    variables.lvlLooting = message.data.lvlLooting;
                    variables.copperDurability = message.data.copperDurability;
                    variables.lvlSwiftSneak = message.data.lvlSwiftSneak;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double lvlCurseofVanishing = 0.0;
        public double lvlUnbreaking = 0.0;
        public double lvlMending = 0.0;
        public double lvlProtection = 0.0;
        public double lvlFireProtection = 0.0;
        public double lvlBlastProtection = 0.0;
        public double lvlProjectileProtection = 0.0;
        public double lvlThorns = 0.0;
        public double lvlCurseofBinding = 0.0;
        public double lvlFeatherFalling = 0.0;
        public double lvlDepthStrider = 0.0;
        public double lvlFrostWalker = 0.0;
        public double lvlSoulSpeed = 0.0;
        public double lvlAquaAffinity = 0.0;
        public double lvlRespiration = 0.0;
        public double lvlSharpness = 0.0;
        public double lvlEfficiency = 0.0;
        public double lvlSilkTouch = 0.0;
        public double lvlFortune = 0.0;
        public double lvlSmite = 0.0;
        public double lvlBaneofArthropods = 0.0;
        public double lvlKnockback = 0.0;
        public double lvlSweepingEdge = 0.0;
        public double lvlFireAspect = 0.0;
        public double lvlLooting = 0.0;
        public double copperDurability = 0.0;
        public double lvlSwiftSneak = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CopperToolsExpandedMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("lvlCurseofVanishing", this.lvlCurseofVanishing);
            nbt.m_128347_("lvlUnbreaking", this.lvlUnbreaking);
            nbt.m_128347_("lvlMending", this.lvlMending);
            nbt.m_128347_("lvlProtection", this.lvlProtection);
            nbt.m_128347_("lvlFireProtection", this.lvlFireProtection);
            nbt.m_128347_("lvlBlastProtection", this.lvlBlastProtection);
            nbt.m_128347_("lvlProjectileProtection", this.lvlProjectileProtection);
            nbt.m_128347_("lvlThorns", this.lvlThorns);
            nbt.m_128347_("lvlCurseofBinding", this.lvlCurseofBinding);
            nbt.m_128347_("lvlFeatherFalling", this.lvlFeatherFalling);
            nbt.m_128347_("lvlDepthStrider", this.lvlDepthStrider);
            nbt.m_128347_("lvlFrostWalker", this.lvlFrostWalker);
            nbt.m_128347_("lvlSoulSpeed", this.lvlSoulSpeed);
            nbt.m_128347_("lvlAquaAffinity", this.lvlAquaAffinity);
            nbt.m_128347_("lvlRespiration", this.lvlRespiration);
            nbt.m_128347_("lvlSharpness", this.lvlSharpness);
            nbt.m_128347_("lvlEfficiency", this.lvlEfficiency);
            nbt.m_128347_("lvlSilkTouch", this.lvlSilkTouch);
            nbt.m_128347_("lvlFortune", this.lvlFortune);
            nbt.m_128347_("lvlSmite", this.lvlSmite);
            nbt.m_128347_("lvlBaneofArthropods", this.lvlBaneofArthropods);
            nbt.m_128347_("lvlKnockback", this.lvlKnockback);
            nbt.m_128347_("lvlSweepingEdge", this.lvlSweepingEdge);
            nbt.m_128347_("lvlFireAspect", this.lvlFireAspect);
            nbt.m_128347_("lvlLooting", this.lvlLooting);
            nbt.m_128347_("copperDurability", this.copperDurability);
            nbt.m_128347_("lvlSwiftSneak", this.lvlSwiftSneak);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.lvlCurseofVanishing = nbt.m_128459_("lvlCurseofVanishing");
            this.lvlUnbreaking = nbt.m_128459_("lvlUnbreaking");
            this.lvlMending = nbt.m_128459_("lvlMending");
            this.lvlProtection = nbt.m_128459_("lvlProtection");
            this.lvlFireProtection = nbt.m_128459_("lvlFireProtection");
            this.lvlBlastProtection = nbt.m_128459_("lvlBlastProtection");
            this.lvlProjectileProtection = nbt.m_128459_("lvlProjectileProtection");
            this.lvlThorns = nbt.m_128459_("lvlThorns");
            this.lvlCurseofBinding = nbt.m_128459_("lvlCurseofBinding");
            this.lvlFeatherFalling = nbt.m_128459_("lvlFeatherFalling");
            this.lvlDepthStrider = nbt.m_128459_("lvlDepthStrider");
            this.lvlFrostWalker = nbt.m_128459_("lvlFrostWalker");
            this.lvlSoulSpeed = nbt.m_128459_("lvlSoulSpeed");
            this.lvlAquaAffinity = nbt.m_128459_("lvlAquaAffinity");
            this.lvlRespiration = nbt.m_128459_("lvlRespiration");
            this.lvlSharpness = nbt.m_128459_("lvlSharpness");
            this.lvlEfficiency = nbt.m_128459_("lvlEfficiency");
            this.lvlSilkTouch = nbt.m_128459_("lvlSilkTouch");
            this.lvlFortune = nbt.m_128459_("lvlFortune");
            this.lvlSmite = nbt.m_128459_("lvlSmite");
            this.lvlBaneofArthropods = nbt.m_128459_("lvlBaneofArthropods");
            this.lvlKnockback = nbt.m_128459_("lvlKnockback");
            this.lvlSweepingEdge = nbt.m_128459_("lvlSweepingEdge");
            this.lvlFireAspect = nbt.m_128459_("lvlFireAspect");
            this.lvlLooting = nbt.m_128459_("lvlLooting");
            this.copperDurability = nbt.m_128459_("copperDurability");
            this.lvlSwiftSneak = nbt.m_128459_("lvlSwiftSneak");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("copper_tools_expanded", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.lvlCurseofVanishing = original.lvlCurseofVanishing;
            clone.lvlUnbreaking = original.lvlUnbreaking;
            clone.lvlMending = original.lvlMending;
            clone.lvlProtection = original.lvlProtection;
            clone.lvlFireProtection = original.lvlFireProtection;
            clone.lvlBlastProtection = original.lvlBlastProtection;
            clone.lvlProjectileProtection = original.lvlProjectileProtection;
            clone.lvlThorns = original.lvlThorns;
            clone.lvlCurseofBinding = original.lvlCurseofBinding;
            clone.lvlFeatherFalling = original.lvlFeatherFalling;
            clone.lvlDepthStrider = original.lvlDepthStrider;
            clone.lvlFrostWalker = original.lvlFrostWalker;
            clone.lvlSoulSpeed = original.lvlSoulSpeed;
            clone.lvlAquaAffinity = original.lvlAquaAffinity;
            clone.lvlRespiration = original.lvlRespiration;
            clone.lvlSharpness = original.lvlSharpness;
            clone.lvlEfficiency = original.lvlEfficiency;
            clone.lvlSilkTouch = original.lvlSilkTouch;
            clone.lvlFortune = original.lvlFortune;
            clone.lvlSmite = original.lvlSmite;
            clone.lvlBaneofArthropods = original.lvlBaneofArthropods;
            clone.lvlKnockback = original.lvlKnockback;
            clone.lvlSweepingEdge = original.lvlSweepingEdge;
            clone.lvlFireAspect = original.lvlFireAspect;
            clone.lvlLooting = original.lvlLooting;
            clone.copperDurability = original.copperDurability;
            clone.lvlSwiftSneak = original.lvlSwiftSneak;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }
    }
}

