/*
 * Decompiled with CFR 0.152.
 */
package hu.jgj52.catcapes.client;

import hu.jgj52.catcapes.client.ConfigFile;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Utils {
    private static final Map<String, class_2960> CAPE_CACHE = new ConcurrentHashMap<String, class_2960>();
    private static final Map<UUID, String> PLAYER_CACHE = new ConcurrentHashMap<UUID, String>();
    private static final Set<UUID> LOADING = ConcurrentHashMap.newKeySet();
    private static final Set<UUID> NO_CAPE = ConcurrentHashMap.newKeySet();

    public static class_2960 downloadCape(UUID uuid) {
        if (NO_CAPE.contains(uuid)) {
            return null;
        }
        if (LOADING.contains(uuid)) {
            return null;
        }
        String name = PLAYER_CACHE.get(uuid);
        if (name != null) {
            return CAPE_CACHE.get(name);
        }
        LOADING.add(uuid);
        new Thread(() -> {
            try {
                String capeName;
                if (uuid.equals(class_310.method_1551().field_1724.method_7334().getId()) && !ConfigFile.get("cape", "").isEmpty()) {
                    capeName = ConfigFile.get("cape", "");
                    PLAYER_CACHE.put(uuid, capeName);
                } else {
                    HttpURLConnection conn = (HttpURLConnection)new URL("https://catcapes.jgj52.hu/player/" + String.valueOf(uuid)).openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    int responseCode = conn.getResponseCode();
                    if (responseCode != 200) {
                        NO_CAPE.add(uuid);
                        LOADING.remove(uuid);
                        return;
                    }
                    try (InputStream in = conn.getInputStream();){
                        capeName = new String(in.readAllBytes()).trim();
                    }
                    PLAYER_CACHE.put(uuid, capeName);
                }
                if (CAPE_CACHE.containsKey(capeName)) {
                    LOADING.remove(uuid);
                    return;
                }
                Path capePath = FabricLoader.getInstance().getGameDir().resolve("capes/" + capeName);
                Files.createDirectories(capePath.getParent(), new FileAttribute[0]);
                if (!Files.exists(capePath, new LinkOption[0])) {
                    try (InputStream in = new URL("https://catcapes.jgj52.hu/cape/" + capeName).openStream();){
                        Files.copy(in, capePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                class_1011 img = class_1011.method_4309((InputStream)Files.newInputStream(capePath, new OpenOption[0]));
                class_2960 textureId = class_2960.method_60655((String)"catcapes", (String)("capes/" + capeName));
                class_310.method_1551().execute(() -> {
                    class_1043 texture = new class_1043(img);
                    class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
                    texture.method_4524();
                    CAPE_CACHE.put(capeName, textureId);
                });
            }
            catch (Exception e) {
                NO_CAPE.add(uuid);
                System.err.println("Failed to load cape for " + String.valueOf(uuid) + ": " + e.getMessage());
            }
            finally {
                LOADING.remove(uuid);
            }
        }, "Cape-Loader-" + String.valueOf(uuid)).start();
        return null;
    }

    public static void reloadCapes() {
        PLAYER_CACHE.clear();
        NO_CAPE.clear();
    }

    public static void removePlayerCache(UUID uuid) {
        PLAYER_CACHE.remove(uuid);
    }
}

