/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import toastysmobs.client.model.ModelWorm;
import toastysmobs.client.model.animations.WormAnimation;
import toastysmobs.entity.WormEntity;

public class WormRenderer
extends MobRenderer<WormEntity, LivingEntityRenderState, ModelWorm> {
    private WormEntity entity = null;

    public WormRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelWorm.LAYER_LOCATION)), 0.1f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(WormEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/wormfinished.png");
    }

    private static final class AnimatedModel
    extends ModelWorm {
        private WormEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(WormEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, WormAnimation.walk, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

