/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.init;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import toastysmobs.init.ToastysmobsModScreens;
import toastysmobs.network.MenuStateUpdateMessage;
import toastysmobs.world.inventory.ToastysGuidePage1Menu;
import toastysmobs.world.inventory.ToastysGuidePage2Menu;
import toastysmobs.world.inventory.ToastysGuidePage3Menu;
import toastysmobs.world.inventory.ToastysGuidePage4Menu;
import toastysmobs.world.inventory.ToastysGuidePage5Menu;
import toastysmobs.world.inventory.ToastysGuideRecipesPage1Menu;
import toastysmobs.world.inventory.ToastysGuideRecipesPage2Menu;

public class ToastysmobsModMenus {
    public static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"toastysmobs");
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuidePage1Menu>> TOASTYS_GUIDE_PAGE_1 = REGISTRY.register("toastys_guide_page_1", () -> IMenuTypeExtension.create(ToastysGuidePage1Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuidePage2Menu>> TOASTYS_GUIDE_PAGE_2 = REGISTRY.register("toastys_guide_page_2", () -> IMenuTypeExtension.create(ToastysGuidePage2Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuideRecipesPage1Menu>> TOASTYS_GUIDE_RECIPES_PAGE_1 = REGISTRY.register("toastys_guide_recipes_page_1", () -> IMenuTypeExtension.create(ToastysGuideRecipesPage1Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuideRecipesPage2Menu>> TOASTYS_GUIDE_RECIPES_PAGE_2 = REGISTRY.register("toastys_guide_recipes_page_2", () -> IMenuTypeExtension.create(ToastysGuideRecipesPage2Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuidePage3Menu>> TOASTYS_GUIDE_PAGE_3 = REGISTRY.register("toastys_guide_page_3", () -> IMenuTypeExtension.create(ToastysGuidePage3Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuidePage4Menu>> TOASTYS_GUIDE_PAGE_4 = REGISTRY.register("toastys_guide_page_4", () -> IMenuTypeExtension.create(ToastysGuidePage4Menu::new));
    public static final DeferredHolder<MenuType<?>, MenuType<ToastysGuidePage5Menu>> TOASTYS_GUIDE_PAGE_5 = REGISTRY.register("toastys_guide_page_5", () -> IMenuTypeExtension.create(ToastysGuidePage5Menu::new));

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, Slot> getSlots();

        default public void sendMenuStateUpdate(Player player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            this.getMenuState().put(elementType + ":" + name, elementState);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else if (player.level().isClientSide) {
                Screen screen = Minecraft.getInstance().screen;
                if (screen instanceof ToastysmobsModScreens.ScreenAccessor) {
                    ToastysmobsModScreens.ScreenAccessor accessor = (ToastysmobsModScreens.ScreenAccessor)screen;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new MenuStateUpdateMessage(elementType, name, elementState), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

