/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelokapi<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"modelokapi"), "main");
    public final ModelPart okapi;
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart head;
    public final ModelPart right_ear;
    public final ModelPart left_ear;
    public final ModelPart f_legs;
    public final ModelPart front_left_leg;
    public final ModelPart front_right_leg;
    public final ModelPart tail;
    public final ModelPart b_legs;
    public final ModelPart back_left_leg;
    public final ModelPart back_right_leg;

    public Modelokapi(ModelPart root) {
        this.okapi = root.getChild("okapi");
        this.body = this.okapi.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.right_ear = this.head.getChild("right_ear");
        this.left_ear = this.head.getChild("left_ear");
        this.f_legs = this.body.getChild("f_legs");
        this.front_left_leg = this.f_legs.getChild("front_left_leg");
        this.front_right_leg = this.f_legs.getChild("front_right_leg");
        this.tail = this.body.getChild("tail");
        this.b_legs = this.okapi.getChild("b_legs");
        this.back_left_leg = this.b_legs.getChild("back_left_leg");
        this.back_right_leg = this.b_legs.getChild("back_right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition okapi = partdefinition.addOrReplaceChild("okapi", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.0f, (float)4.0f));
        PartDefinition body = okapi.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -21.0f, -12.0f, 10.0f, 11.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 28).addBox(-2.0f, -10.0f, -4.0f, 4.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-17.0f, (float)-9.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(22, 28).addBox(-3.0f, -11.0f, -3.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(16, 47).addBox(1.0f, -13.0f, 0.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(54, 20).addBox(-2.0f, -13.0f, 0.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 41).addBox(-2.0f, -11.0f, -9.0f, 4.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(32, 52).addBox(-3.0f, -14.0f, 4.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)0.0f, (float)-2.01f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(54, 15).addBox(0.0f, -14.0f, 4.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)-2.01f));
        PartDefinition f_legs = body.addOrReplaceChild("f_legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front_left_leg = f_legs.addOrReplaceChild("front_left_leg", CubeListBuilder.create().texOffs(42, 41).addBox(-3.0f, -1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-9.0f, (float)-10.0f));
        PartDefinition front_right_leg = f_legs.addOrReplaceChild("front_right_leg", CubeListBuilder.create().texOffs(0, 47).addBox(-1.0f, -1.0f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-9.0f, (float)-10.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(50, 30).addBox(-1.5f, 0.0f, 0.01f, 3.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-20.0f, (float)5.0f));
        PartDefinition b_legs = okapi.addOrReplaceChild("b_legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition back_left_leg = b_legs.addOrReplaceChild("back_left_leg", CubeListBuilder.create().texOffs(16, 52).addBox(-3.0f, -1.0f, -1.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-9.0f, (float)5.0f));
        PartDefinition back_right_leg = b_legs.addOrReplaceChild("back_right_leg", CubeListBuilder.create().texOffs(54, 0).addBox(-1.0f, -1.0f, -1.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-9.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.okapi.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.front_right_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.back_right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.neck.yRot = netHeadYaw / 57.295776f;
        this.neck.xRot = headPitch / 57.295776f;
        this.front_left_leg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.back_left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

