/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelCrab
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"model_crab"), "main");
    public final ModelPart crab;
    public final ModelPart body;
    public final ModelPart eyes;
    public final ModelPart leftclaw;
    public final ModelPart rightclaw;
    public final ModelPart bone2;
    public final ModelPart rightlegs;
    public final ModelPart rleg1;
    public final ModelPart rleg2;
    public final ModelPart rleg3;
    public final ModelPart leftlegs;
    public final ModelPart lleg1;
    public final ModelPart lleg2;
    public final ModelPart lleg3;

    public ModelCrab(ModelPart root) {
        super(root);
        this.crab = root.getChild("crab");
        this.body = this.crab.getChild("body");
        this.eyes = this.crab.getChild("eyes");
        this.leftclaw = this.crab.getChild("leftclaw");
        this.rightclaw = this.crab.getChild("rightclaw");
        this.bone2 = this.crab.getChild("bone2");
        this.rightlegs = this.crab.getChild("rightlegs");
        this.rleg1 = this.rightlegs.getChild("rleg1");
        this.rleg2 = this.rightlegs.getChild("rleg2");
        this.rleg3 = this.rightlegs.getChild("rleg3");
        this.leftlegs = this.crab.getChild("leftlegs");
        this.lleg1 = this.leftlegs.getChild("lleg1");
        this.lleg2 = this.leftlegs.getChild("lleg2");
        this.lleg3 = this.leftlegs.getChild("lleg3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition crab = partdefinition.addOrReplaceChild("crab", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)24.0f, (float)-1.0f));
        PartDefinition body = crab.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -2.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)0.0f, (float)1.0f));
        PartDefinition eyes = crab.addOrReplaceChild("eyes", CubeListBuilder.create().texOffs(16, 20).addBox(-1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(18, 20).addBox(-6.0f, -1.0f, 1.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.0f, (float)-2.0f));
        PartDefinition leftclaw = crab.addOrReplaceChild("leftclaw", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)0.0f, (float)-3.0f));
        PartDefinition cube_r1 = leftclaw.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, -2.5f, -4.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition rightclaw = crab.addOrReplaceChild("rightclaw", CubeListBuilder.create(), PartPose.offset((float)-10.0f, (float)0.0f, (float)-3.0f));
        PartDefinition cube_r2 = rightclaw.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(12, 11).addBox(-1.9962f, -2.5f, -3.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition bone2 = crab.addOrReplaceChild("bone2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightlegs = crab.addOrReplaceChild("rightlegs", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-1.0f, (float)0.0f));
        PartDefinition rleg1 = rightlegs.addOrReplaceChild("rleg1", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(8, 20).addBox(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rleg2 = rightlegs.addOrReplaceChild("rleg2", CubeListBuilder.create().texOffs(6, 18).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 20).addBox(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition rleg3 = rightlegs.addOrReplaceChild("rleg3", CubeListBuilder.create().texOffs(12, 18).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(4, 20).addBox(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition leftlegs = crab.addOrReplaceChild("leftlegs", CubeListBuilder.create(), PartPose.offset((float)-11.0f, (float)-1.0f, (float)4.0f));
        PartDefinition lleg1 = leftlegs.addOrReplaceChild("lleg1", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 16).addBox(-2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition lleg2 = leftlegs.addOrReplaceChild("lleg2", CubeListBuilder.create().texOffs(18, 18).addBox(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 16).addBox(1.0f, -2.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.0f, (float)-2.0f));
        PartDefinition lleg3 = leftlegs.addOrReplaceChild("lleg3", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(12, 16).addBox(1.0f, -2.0f, 0.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.lleg1.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.rleg1.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rleg3.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.rleg2.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.lleg2.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.lleg3.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

