/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import toastysmobs.client.model.Modelduck;
import toastysmobs.client.model.animations.duckAnimation;
import toastysmobs.entity.DuckEntity;
import toastysmobs.procedures.DuckDisplayConditionProcedure;

public class DuckRenderer
extends MobRenderer<DuckEntity, LivingEntityRenderState, Modelduck> {
    private DuckEntity entity = null;

    public DuckRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelduck.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelduck>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"toastysmobs:textures/entities/duckling2.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = DuckRenderer.this.entity.level();
                double x = DuckRenderer.this.entity.getX();
                double y = DuckRenderer.this.entity.getY();
                double z = DuckRenderer.this.entity.getZ();
                if (DuckDisplayConditionProcedure.execute((Entity)DuckRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelduck)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(DuckEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/duck3.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelduck {
        private DuckEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(DuckEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, duckAnimation.swim, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

