/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import toastysmobs.client.model.ModelWorm;
import toastysmobs.client.model.animations.WormAnimation;
import toastysmobs.entity.WormEntity;

public class WormRenderer
extends MobRenderer<WormEntity, ModelWorm<WormEntity>> {
    public WormRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelWorm.LAYER_LOCATION)), 0.1f);
    }

    public ResourceLocation getTextureLocation(WormEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/wormfinished.png");
    }

    private static final class AnimatedModel
    extends ModelWorm<WormEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<WormEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(WormEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, WormAnimation.walk, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(WormEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

