/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelduckymodel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"toastysmobs", (String)"modelduckymodel"), "main");
    public final ModelPart duck;
    public final ModelPart right_leg;
    public final ModelPart left_leg;
    public final ModelPart right_wing;
    public final ModelPart left_wing;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart bill;

    public Modelduckymodel(ModelPart root) {
        this.duck = root.getChild("duck");
        this.right_leg = this.duck.getChild("right_leg");
        this.left_leg = this.duck.getChild("left_leg");
        this.right_wing = this.duck.getChild("right_wing");
        this.left_wing = this.duck.getChild("left_wing");
        this.body = this.duck.getChild("body");
        this.head = this.duck.getChild("head");
        this.bill = this.head.getChild("bill");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition duck = partdefinition.addOrReplaceChild("duck", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)20.0f, (float)1.0f));
        PartDefinition right_leg = duck.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 6).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = duck.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, 1.0f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_wing = duck.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 12).addBox(1.0f, 4.0f, -3.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition left_wing = duck.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, 4.0f, -3.0f, 1.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition body = duck.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -5.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-4.0f, (float)-1.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = duck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(14, 12).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-3.0f, (float)-4.0f));
        PartDefinition bill = head.addOrReplaceChild("bill", CubeListBuilder.create().texOffs(14, 20).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.duck.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

