/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import toastysmobs.client.model.Modelduckymodel;
import toastysmobs.client.model.animations.duckmodelAnimation;
import toastysmobs.entity.DuckEntity;

public class DuckRenderer
extends MobRenderer<DuckEntity, Modelduckymodel<DuckEntity>> {
    public DuckRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelduckymodel.LAYER_LOCATION)), 0.5f);
    }

    protected void scale(DuckEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(DuckEntity entity) {
        return ResourceLocation.parse((String)"toastysmobs:textures/entities/finalduck.png");
    }

    private static final class AnimatedModel
    extends Modelduckymodel<DuckEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<DuckEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(DuckEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, duckmodelAnimation.fly, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(DuckEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

