/*
 * Decompiled with CFR 0.152.
 */
package toastysmobs.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import toastysmobs.entity.BearEntity;
import toastysmobs.entity.CrabEntity;
import toastysmobs.entity.DuckEntity;
import toastysmobs.entity.SeaHareEntity;
import toastysmobs.entity.ToxinEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ToastysmobsModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"toastysmobs");
    public static final DeferredHolder<EntityType<?>, EntityType<BearEntity>> BEAR = ToastysmobsModEntities.register("bear", EntityType.Builder.of(BearEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DuckEntity>> DUCK = ToastysmobsModEntities.register("duck", EntityType.Builder.of(DuckEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<CrabEntity>> CRAB = ToastysmobsModEntities.register("crab", EntityType.Builder.of(CrabEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<SeaHareEntity>> SEA_HARE = ToastysmobsModEntities.register("sea_hare", EntityType.Builder.of(SeaHareEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.2f, 0.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<ToxinEntity>> TOXIN = ToastysmobsModEntities.register("toxin", EntityType.Builder.of(ToxinEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        BearEntity.init(event);
        DuckEntity.init(event);
        CrabEntity.init(event);
        SeaHareEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BEAR.get(), BearEntity.createAttributes().build());
        event.put((EntityType)DUCK.get(), DuckEntity.createAttributes().build());
        event.put((EntityType)CRAB.get(), CrabEntity.createAttributes().build());
        event.put((EntityType)SEA_HARE.get(), SeaHareEntity.createAttributes().build());
    }
}

