package net.myitian.no_caves;

import com.mojang.serialization.DataResult;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7924;

public final class RegistryLoaderHelper {
    public static Object process(class_5321<?> key, Object rawValue) {
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional<?> optional) {
            // NeoForge modified some mechanisms so that the decoder returns an optional.
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        class_2960 registryId = key.method_41185();
        if (registryId.equals(class_7924.field_41243.method_29177())) {
            if (value instanceof class_5284 checkedValue) {
                processChunkGeneratorSettings(key.method_29177(), checkedValue);
            }
        } else if (registryId.equals(class_7924.field_41240.method_29177())) {
            if (value instanceof class_6910 checkedValue) {
                value = processDensityFunction(key.method_29177(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals(class_7924.field_41236.method_29177())) {
            if (value instanceof class_1959 checkedValue) {
                processBiome(key.method_29177(), checkedValue);
            }
        }
        if (!newObject) {
            return rawValue;
        } else if (useOptional) {
            return Optional.of(value);
        } else {
            return value;
        }
    }

    public static void processChunkGeneratorSettings(class_2960 key, class_5284 chunkGeneratorSettings) {
        if (!(NoCaves.isEnableFinalDensityTransformation()
                && !NoCaves.getFinalDensityTransformationExclusionPatterns().matches(key.toString()))) {
            return;
        }
        class_6953 noiseRouter = chunkGeneratorSettings.comp_477();
        class_6910 finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.comp_487());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn(
                    "Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.",
                    key);
            finalDensity = class_6916.method_40479();
        }
        noiseRouter.comp_487 = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}",
                ++NoCaves.transformedFinalDensity,
                key);
    }

    public static class_6910 processDensityFunction(class_2960 key, class_6910 densityFunction) {
        if (!(NoCaves.isEnableDensityFunctionTransformation()
                && NoCaves.getDensityFunctionToTransformPatterns().matches(key.toString()))) {
            return densityFunction;
        }
        densityFunction = DensityFunctionCaveCleaner.transform(densityFunction);
        if (densityFunction == null) {
            NoCaves.LOGGER.warn(
                    "Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.",
                    key);
            densityFunction = class_6916.method_40479();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}",
                ++NoCaves.transformedDensityFunctions,
                key);
        return densityFunction;
    }

    public static void processBiome(class_2960 key, class_1959 biome) {
        if (!(NoCaves.isEnableCarverFilter()
                && !NoCaves.getCarverFilterBiomeExclusionPatterns().matches(key.toString()))) {
            return;
        }
        class_5485 generationSettings = biome.method_30970();
        @SuppressWarnings("unchecked")
        Pair<class_2893.class_2894, class_6885<class_2922<?>>>[] carvers = new Pair[generationSettings.field_26415.size()];
        int i = 0;
        for (var entry : generationSettings.field_26415.entrySet()) {
            class_6885<class_2922<?>> originalList = entry.getValue();
            ArrayList<class_6880<class_2922<?>>> list = new ArrayList<>(originalList.method_40247());
            for (var regEntry : originalList) {
                Optional<class_5321<class_2922<?>>> regKey = regEntry.method_40230();
                if (regKey.isPresent() && !NoCaves.getDisabledCarverPatterns().matches(regKey.get().method_29177().toString())) {
                    list.add(regEntry);
                }
            }
            carvers[i++] = Pair.of(entry.getKey(), class_6885.method_40242(list));
        }
        generationSettings.field_26415 = Map.ofEntries(carvers);
        NoCaves.LOGGER.debug(
                "NoCaves.processedGenerationSettings {} {}",
                ++NoCaves.processedGenerationSettings,
                key);
    }
}
