/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.myitian.no_caves.DensityFunctionCaveCleaner;
import net.myitian.no_caves.NoCaves;
import net.myitian.no_caves.PatternSet;
import net.myitian.no_caves.config.Config;

public final class RegistryLoaderHelper {
    public static Object process(ResourceKey<?> key, Object rawValue) {
        ResourceLocation registryId;
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional) {
            Optional optional = (Optional)rawValue;
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        if ((registryId = key.registry()).equals((Object)Registries.NOISE_SETTINGS.location())) {
            if (value instanceof NoiseGeneratorSettings) {
                NoiseGeneratorSettings checkedValue = (NoiseGeneratorSettings)value;
                RegistryLoaderHelper.processChunkGeneratorSettings(key.location(), checkedValue);
            }
        } else if (registryId.equals((Object)Registries.DENSITY_FUNCTION.location())) {
            if (value instanceof DensityFunction) {
                DensityFunction checkedValue = (DensityFunction)value;
                value = RegistryLoaderHelper.processDensityFunction(key.location(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals((Object)Registries.BIOME.location()) && value instanceof Biome) {
            Biome checkedValue = (Biome)value;
            RegistryLoaderHelper.processBiome(key.location(), checkedValue);
        }
        if (!newObject) {
            return rawValue;
        }
        if (useOptional) {
            return Optional.of(value);
        }
        return value;
    }

    public static void processChunkGeneratorSettings(ResourceLocation key, NoiseGeneratorSettings chunkGeneratorSettings) {
        if (!Config.isEnableFinalDensityTransformation() || Config.getFinalDensityTransformationExclusionPatterns().matches(key.toString())) {
            return;
        }
        NoiseRouter noiseRouter = chunkGeneratorSettings.noiseRouter();
        DensityFunction finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.finalDensity());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn("Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.", (Object)key);
            finalDensity = DensityFunctions.zero();
        }
        noiseRouter.finalDensity = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}", (Object)(++NoCaves.transformedFinalDensity), (Object)key);
    }

    public static DensityFunction processDensityFunction(ResourceLocation key, DensityFunction densityFunction) {
        if (!Config.isEnableDensityFunctionTransformation() || !Config.getDensityFunctionToTransformPatterns().matches(key.toString())) {
            return densityFunction;
        }
        if ((densityFunction = DensityFunctionCaveCleaner.transform(densityFunction)) == null) {
            NoCaves.LOGGER.warn("Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.", (Object)key);
            densityFunction = DensityFunctions.zero();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}", (Object)(++NoCaves.transformedDensityFunctions), (Object)key);
        return densityFunction;
    }

    public static void processBiome(ResourceLocation key, Biome biome) {
        if (!Config.isEnableCarverFilter() || Config.getCarverFilterBiomeExclusionPatterns().matches(key.toString())) {
            return;
        }
        BiomeGenerationSettings generationSettings = biome.getGenerationSettings();
        PatternSet patterns = Config.getBiomeSpecificOverrideForDisabledCarverPatterns().getOrDefault(key.toString(), Config.getDisabledCarverPatterns());
        ArrayList<Holder> carvers = new ArrayList<Holder>(generationSettings.carvers.size());
        for (Holder entry : generationSettings.carvers) {
            Optional regKey = entry.unwrapKey();
            if (!regKey.isPresent() || patterns.matches(((ResourceKey)regKey.get()).location().toString())) continue;
            carvers.add(entry);
        }
        generationSettings.carvers = HolderSet.direct(carvers);
        NoCaves.LOGGER.debug("NoCaves.processedGenerationSettings {} {}", (Object)(++NoCaves.processedGenerationSettings), (Object)key);
    }
}

