/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.myitian.no_caves.DensityFunctionCaveCleaner;
import net.myitian.no_caves.NoCaves;
import org.apache.commons.lang3.tuple.Pair;

public final class RegistryLoaderHelper {
    public static Object process(ResourceKey<?> key, Object rawValue) {
        ResourceLocation registryId;
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional) {
            Optional optional = (Optional)rawValue;
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        if ((registryId = key.registry()).equals((Object)Registries.NOISE_SETTINGS.location())) {
            if (value instanceof NoiseGeneratorSettings) {
                NoiseGeneratorSettings checkedValue = (NoiseGeneratorSettings)value;
                RegistryLoaderHelper.processChunkGeneratorSettings(key.location(), checkedValue);
            }
        } else if (registryId.equals((Object)Registries.DENSITY_FUNCTION.location())) {
            if (value instanceof DensityFunction) {
                DensityFunction checkedValue = (DensityFunction)value;
                value = RegistryLoaderHelper.processDensityFunction(key.location(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals((Object)Registries.BIOME.location()) && value instanceof Biome) {
            Biome checkedValue = (Biome)value;
            RegistryLoaderHelper.processBiome(key.location(), checkedValue);
        }
        if (!newObject) {
            return rawValue;
        }
        if (useOptional) {
            return Optional.of(value);
        }
        return value;
    }

    public static void processChunkGeneratorSettings(ResourceLocation key, NoiseGeneratorSettings chunkGeneratorSettings) {
        if (!NoCaves.isEnableFinalDensityTransformation() || NoCaves.getFinalDensityTransformationExclusionPatterns().matches(key.toString())) {
            return;
        }
        NoiseRouter noiseRouter = chunkGeneratorSettings.noiseRouter();
        DensityFunction finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.finalDensity());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn("Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.", (Object)key);
            finalDensity = DensityFunctions.zero();
        }
        noiseRouter.finalDensity = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}", (Object)(++NoCaves.transformedFinalDensity), (Object)key);
    }

    public static DensityFunction processDensityFunction(ResourceLocation key, DensityFunction densityFunction) {
        if (!NoCaves.isEnableDensityFunctionTransformation() || !NoCaves.getDensityFunctionToTransformPatterns().matches(key.toString())) {
            return densityFunction;
        }
        if ((densityFunction = DensityFunctionCaveCleaner.transform(densityFunction)) == null) {
            NoCaves.LOGGER.warn("Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.", (Object)key);
            densityFunction = DensityFunctions.zero();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}", (Object)(++NoCaves.transformedDensityFunctions), (Object)key);
        return densityFunction;
    }

    public static void processBiome(ResourceLocation key, Biome biome) {
        if (!NoCaves.isEnableCarverFilter() || NoCaves.getCarverFilterBiomeExclusionPatterns().matches(key.toString())) {
            return;
        }
        BiomeGenerationSettings generationSettings = biome.getGenerationSettings();
        Pair[] carvers = new Pair[generationSettings.carvers.size()];
        int i = 0;
        for (Map.Entry entry : generationSettings.carvers.entrySet()) {
            HolderSet originalList = (HolderSet)entry.getValue();
            ArrayList<Holder> list = new ArrayList<Holder>(originalList.size());
            for (Holder regEntry : originalList) {
                Optional regKey = regEntry.unwrapKey();
                if (!regKey.isPresent() || NoCaves.getDisabledCarverPatterns().matches(((ResourceKey)regKey.get()).location().toString())) continue;
                list.add(regEntry);
            }
            carvers[i++] = Pair.of((Object)((GenerationStep.Carving)entry.getKey()), (Object)HolderSet.direct(list));
        }
        generationSettings.carvers = Map.ofEntries(carvers);
        NoCaves.LOGGER.debug("NoCaves.processedGenerationSettings {} {}", (Object)(++NoCaves.processedGenerationSettings), (Object)key);
    }
}

