package net.myitian.no_caves;

import com.mojang.serialization.DataResult;
import org.apache.commons.lang3.tuple.Pair;

import java.util.ArrayList;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;

public final class RegistryLoaderHelper {
    public static Object process(ResourceKey<?> key, Object rawValue) {
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional<?> optional) {
            // NeoForge modified some mechanisms so that the decoder returns an optional.
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        ResourceLocation registryId = key.m_211136_();
        if (registryId.equals(Registries.f_256932_.m_135782_())) {
            if (value instanceof NoiseGeneratorSettings checkedValue) {
                processChunkGeneratorSettings(key.m_135782_(), checkedValue);
            }
        } else if (registryId.equals(Registries.f_257040_.m_135782_())) {
            if (value instanceof DensityFunction checkedValue) {
                value = processDensityFunction(key.m_135782_(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals(Registries.f_256952_.m_135782_())) {
            if (value instanceof Biome checkedValue) {
                processBiome(key.m_135782_(), checkedValue);
            }
        }
        if (!newObject) {
            return rawValue;
        } else if (useOptional) {
            return Optional.of(value);
        } else {
            return value;
        }
    }

    public static void processChunkGeneratorSettings(ResourceLocation key, NoiseGeneratorSettings chunkGeneratorSettings) {
        if (!(NoCaves.isEnableFinalDensityTransformation()
                && !NoCaves.getFinalDensityTransformationExclusionPatterns().matches(key.toString()))) {
            return;
        }
        NoiseRouter noiseRouter = chunkGeneratorSettings.f_209353_();
        DensityFunction finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.f_209391_());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn(
                    "Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.",
                    key);
            finalDensity = DensityFunctions.m_208263_();
        }
        noiseRouter.f_209391_ = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}",
                ++NoCaves.transformedFinalDensity,
                key);
    }

    public static DensityFunction processDensityFunction(ResourceLocation key, DensityFunction densityFunction) {
        if (!(NoCaves.isEnableDensityFunctionTransformation()
                && NoCaves.getDensityFunctionToTransformPatterns().matches(key.toString()))) {
            return densityFunction;
        }
        densityFunction = DensityFunctionCaveCleaner.transform(densityFunction);
        if (densityFunction == null) {
            NoCaves.LOGGER.warn(
                    "Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.",
                    key);
            densityFunction = DensityFunctions.m_208263_();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}",
                ++NoCaves.transformedDensityFunctions,
                key);
        return densityFunction;
    }

    public static void processBiome(ResourceLocation key, Biome biome) {
        if (!(NoCaves.isEnableCarverFilter()
                && !NoCaves.getCarverFilterBiomeExclusionPatterns().matches(key.toString()))) {
            return;
        }
        BiomeGenerationSettings generationSettings = biome.m_47536_();
        @SuppressWarnings("unchecked")
        Pair<GenerationStep.Carving, HolderSet<ConfiguredWorldCarver<?>>>[] carvers = new Pair[generationSettings.f_47780_.size()];
        int i = 0;
        for (var entry : generationSettings.f_47780_.entrySet()) {
            HolderSet<ConfiguredWorldCarver<?>> originalList = entry.getValue();
            ArrayList<Holder<ConfiguredWorldCarver<?>>> list = new ArrayList<>(originalList.m_203632_());
            for (var regEntry : originalList) {
                Optional<ResourceKey<ConfiguredWorldCarver<?>>> regKey = regEntry.m_203543_();
                if (regKey.isPresent() && !NoCaves.getDisabledCarverPatterns().matches(regKey.get().m_135782_().toString())) {
                    list.add(regEntry);
                }
            }
            carvers[i++] = Pair.of(entry.getKey(), HolderSet.m_205800_(list));
        }
        generationSettings.f_47780_ = Map.ofEntries(carvers);
        NoCaves.LOGGER.debug(
                "NoCaves.processedGenerationSettings {} {}",
                ++NoCaves.processedGenerationSettings,
                key);
    }
}
