/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PatternSet
extends AbstractSet<Pattern> {
    private final HashMap<PatternKey, Pattern> map;

    public PatternSet() {
        this.map = new HashMap();
    }

    public PatternSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    public PatternSet(Collection<? extends Pattern> patterns) {
        this(patterns.size());
        this.addAll(patterns);
    }

    public PatternSet(Pattern ... patterns) {
        this(Arrays.asList(patterns));
    }

    public boolean matches(String str) {
        for (Pattern pattern : this.map.values()) {
            if (!pattern.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        Set set;
        block6: {
            block5: {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Set)) break block5;
                set = (Set)o;
                if (this.size() == set.size()) break block6;
            }
            return false;
        }
        if (set instanceof PatternSet) {
            PatternSet patternSet = (PatternSet)set;
            return this.map.keySet().containsAll(patternSet.map.keySet());
        }
        return this.containsAll(set);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (PatternKey key : this.map.keySet()) {
            h += key.hashCode();
        }
        return h;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Iterator<Pattern> iterator() {
        return new PatternIterator();
    }

    @Override
    public void forEach(Consumer<? super Pattern> action) {
        this.map.values().forEach(action);
    }

    @Override
    public <T> T[] toArray(@NotNull IntFunction<T[]> generator) {
        return this.map.values().toArray(generator);
    }

    @Override
    @NotNull
    public Spliterator<Pattern> spliterator() {
        return this.map.values().spliterator();
    }

    @Override
    @NotNull
    public Stream<Pattern> stream() {
        return this.map.values().stream();
    }

    @Override
    @NotNull
    public Stream<Pattern> parallelStream() {
        return this.map.values().parallelStream();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            return this.map.containsKey(new PatternKey(pattern));
        }
        if (o instanceof PatternKey) {
            PatternKey key = (PatternKey)o;
            return this.map.containsKey(key);
        }
        return false;
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        return this.map.values().toArray(a);
    }

    @Override
    public boolean add(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        return this.map.put(new PatternKey(pattern), pattern) == null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Pattern) {
            Pattern pattern = (Pattern)o;
            return this.map.remove(new PatternKey(pattern)) != null;
        }
        if (o instanceof PatternKey) {
            PatternKey key = (PatternKey)o;
            return this.map.remove(key) != null;
        }
        return false;
    }

    private record PatternKey(String pattern, int flags) {
        public PatternKey(Pattern pattern) {
            this(pattern.pattern(), pattern.flags());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof PatternKey)) return false;
            PatternKey key = (PatternKey)o;
            if (!this.pattern.equals(key.pattern)) return false;
            if (this.flags != key.flags) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return 31 * this.pattern.hashCode() + this.flags;
        }
    }

    private class PatternIterator
    implements Iterator<Pattern> {
        private final Iterator<Map.Entry<PatternKey, Pattern>> iterator;
        private Map.Entry<PatternKey, Pattern> current;
        private boolean canRemove;

        public PatternIterator() {
            this.iterator = PatternSet.this.map.entrySet().iterator();
            this.canRemove = false;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Pattern next() {
            this.current = this.iterator.next();
            this.canRemove = true;
            return this.current.getValue();
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            this.iterator.remove();
            this.canRemove = false;
        }

        @Override
        public void forEachRemaining(Consumer<? super Pattern> action) {
            Objects.requireNonNull(action);
            this.iterator.forEachRemaining((? super E entry) -> {
                this.current = entry;
                action.accept((Pattern)this.current.getValue());
            });
            this.canRemove = false;
        }
    }
}

