/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.myitian.no_caves.config.Config;
import org.jetbrains.annotations.Nullable;

public final class DensityFunctionCaveCleaner {
    private static final Map<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>> customTransformerRegistry = new LinkedHashMap<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>>();

    public static Map<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, @Nullable DensityFunction>>> getCustomTransformerRegistry() {
        return customTransformerRegistry;
    }

    @Nullable
    public static DensityFunction transform(DensityFunction original) {
        if (!customTransformerRegistry.isEmpty()) {
            for (Map.Entry<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>> entry : customTransformerRegistry.entrySet()) {
                String id = entry.getKey();
                try {
                    Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>> pair = entry.getValue();
                    if (pair == null || pair.getA() == null || pair.getB() == null || !((Predicate)pair.getA()).test(original)) continue;
                    return (DensityFunction)((Function)pair.getB()).apply(original);
                }
                catch (Exception e) {
                    throw new RuntimeException("An unhandled exception occurred in transformer " + id, e);
                }
            }
        } else {
            if (original instanceof DensityFunctions.HolderHolder) {
                DensityFunctions.HolderHolder holder = (DensityFunctions.HolderHolder)original;
                return DensityFunctionCaveCleaner.transformRegistryEntryHolder(holder);
            }
            if (original instanceof DensityFunctions.Noise) {
                DensityFunctions.Noise noise = (DensityFunctions.Noise)original;
                return DensityFunctionCaveCleaner.transformNoise(noise);
            }
            if (original instanceof DensityFunctions.RangeChoice) {
                DensityFunctions.RangeChoice rangeChoice = (DensityFunctions.RangeChoice)original;
                return DensityFunctionCaveCleaner.transformRangeChoice(rangeChoice);
            }
            if (original instanceof DensityFunctions.MulOrAdd) {
                DensityFunctions.MulOrAdd linear = (DensityFunctions.MulOrAdd)original;
                return DensityFunctionCaveCleaner.transformLinear(linear);
            }
            if (original instanceof DensityFunctions.TwoArgumentSimpleFunction) {
                DensityFunctions.TwoArgumentSimpleFunction binary = (DensityFunctions.TwoArgumentSimpleFunction)original;
                return DensityFunctionCaveCleaner.transformBinary(binary);
            }
            if (original instanceof DensityFunctions.PureTransformer) {
                DensityFunctions.PureTransformer unary = (DensityFunctions.PureTransformer)original;
                return DensityFunctionCaveCleaner.transformUnary(unary);
            }
            if (original instanceof DensityFunctions.MarkerOrMarked) {
                DensityFunctions.MarkerOrMarked wrapper = (DensityFunctions.MarkerOrMarked)original;
                return DensityFunctionCaveCleaner.transformWrapper(wrapper);
            }
            if (original instanceof DensityFunctions.TransformerWithContext) {
                DensityFunctions.TransformerWithContext positional = (DensityFunctions.TransformerWithContext)original;
                return DensityFunctionCaveCleaner.transformPositional(positional);
            }
        }
        return original;
    }

    public static boolean isCaveDensityFunction(DensityFunction densityFunction) {
        DensityFunctions.HolderHolder holder;
        return densityFunction instanceof DensityFunctions.HolderHolder && DensityFunctionCaveCleaner.isCaveDensityFunction((Holder<DensityFunction>)(holder = (DensityFunctions.HolderHolder)densityFunction).function());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveDensityFunction(Holder<DensityFunction> densityFunction) {
        if (!(densityFunction instanceof Holder.Reference)) return false;
        Holder.Reference reference = (Holder.Reference)densityFunction;
        if (!Config.getDensityFunctionCavePatterns().matches(reference.key().location().toString())) return false;
        return true;
    }

    public static boolean isCaveNoise(DensityFunction.NoiseHolder noise) {
        return DensityFunctionCaveCleaner.isCaveNoise((Holder<NormalNoise.NoiseParameters>)noise.noiseData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveNoise(Holder<NormalNoise.NoiseParameters> noise) {
        if (!(noise instanceof Holder.Reference)) return false;
        Holder.Reference reference = (Holder.Reference)noise;
        if (!Config.getNoiseCavePatterns().matches(reference.key().location().toString())) return false;
        return true;
    }

    @Nullable
    public static DensityFunction transformRegistryEntryHolder(DensityFunctions.HolderHolder holder) {
        Holder function = holder.function();
        if (Config.isEnableDensityFunctionCaveFilter() && DensityFunctionCaveCleaner.isCaveDensityFunction((Holder<DensityFunction>)function)) {
            return null;
        }
        if (function instanceof Holder.Direct) {
            return DensityFunctionCaveCleaner.transform((DensityFunction)function.value());
        }
        return holder;
    }

    @Nullable
    public static DensityFunction transformNoise(DensityFunctions.Noise noise) {
        return Config.isEnableNoiseCaveFilter() && DensityFunctionCaveCleaner.isCaveNoise(noise.noise()) ? null : noise;
    }

    @Nullable
    private static DensityFunction transformRangeChoice(DensityFunctions.RangeChoice rangeChoice) {
        DensityFunction input = rangeChoice.input();
        if (DensityFunctionCaveCleaner.isCaveDensityFunction(input)) {
            return DensityFunctionCaveCleaner.transform(rangeChoice.whenOutOfRange());
        }
        if (input instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)input;
            double v = constant.value();
            if (v >= rangeChoice.minInclusive() && v < rangeChoice.maxExclusive()) {
                return DensityFunctionCaveCleaner.transform(rangeChoice.whenInRange());
            }
            return DensityFunctionCaveCleaner.transform(rangeChoice.whenOutOfRange());
        }
        DensityFunction originalChild1 = rangeChoice.whenInRange();
        DensityFunction transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        DensityFunction originalChild2 = rangeChoice.whenOutOfRange();
        DensityFunction transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        rangeChoice.whenInRange = transformedChild1;
        rangeChoice.whenOutOfRange = transformedChild2;
        return rangeChoice;
    }

    private static DensityFunction transformLinear(DensityFunctions.MulOrAdd linear) {
        DensityFunction originalChild = linear.input();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return DensityFunctions.constant((double)linear.argument());
        }
        if (transformedChild instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)transformedChild;
            return DensityFunctions.constant((double)linear.transform(constant.value()));
        }
        linear.input = transformedChild;
        return linear;
    }

    @Nullable
    private static DensityFunction transformBinary(DensityFunctions.TwoArgumentSimpleFunction binary) {
        DensityFunction originalChild1 = binary.argument1();
        DensityFunction transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        DensityFunction originalChild2 = binary.argument2();
        DensityFunction transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        if (transformedChild1 instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant1 = (DensityFunctions.Constant)transformedChild1;
            if (transformedChild2 instanceof DensityFunctions.Constant) {
                DensityFunctions.Constant constant2 = (DensityFunctions.Constant)transformedChild2;
                double v1 = constant1.value();
                switch (binary.type()) {
                    case ADD: {
                        return DensityFunctions.constant((double)(v1 + constant2.value()));
                    }
                    case MUL: {
                        return DensityFunctions.constant((double)(v1 == 0.0 ? 0.0 : v1 * constant2.value()));
                    }
                    case MIN: {
                        return DensityFunctions.constant((double)Math.min(v1, constant2.value()));
                    }
                    case MAX: {
                        return DensityFunctions.constant((double)Math.max(v1, constant2.value()));
                    }
                }
            }
        }
        if (originalChild1 != transformedChild1 || originalChild2 != transformedChild2) {
            return DensityFunctions.TwoArgumentSimpleFunction.create((DensityFunctions.TwoArgumentSimpleFunction.Type)binary.type(), (DensityFunction)transformedChild1, (DensityFunction)transformedChild2);
        }
        return binary;
    }

    @Nullable
    private static DensityFunction transformUnary(DensityFunctions.PureTransformer unary) {
        DensityFunction originalChild = unary.input();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)transformedChild;
            return DensityFunctions.constant((double)unary.transform(constant.value()));
        }
        if (transformedChild != originalChild) {
            if (unary instanceof DensityFunctions.Clamp) {
                DensityFunctions.Clamp typedUnary = (DensityFunctions.Clamp)unary;
                typedUnary.input = transformedChild;
            } else if (unary instanceof DensityFunctions.Mapped) {
                DensityFunctions.Mapped typedUnary = (DensityFunctions.Mapped)unary;
                return DensityFunctions.Mapped.create((DensityFunctions.Mapped.Type)typedUnary.type(), (DensityFunction)transformedChild);
            }
        }
        return unary;
    }

    @Nullable
    private static DensityFunction transformWrapper(DensityFunctions.MarkerOrMarked wrapper) {
        DensityFunction originalChild = wrapper.wrapped();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (wrapper instanceof NoiseChunk.Cache2D) {
                NoiseChunk.Cache2D typedWrapper = (NoiseChunk.Cache2D)wrapper;
                typedWrapper.function = transformedChild;
            } else if (wrapper instanceof NoiseChunk.Cache2D) {
                NoiseChunk.Cache2D typedWrapper = (NoiseChunk.Cache2D)wrapper;
                typedWrapper.function = transformedChild;
            } else if (wrapper instanceof NoiseChunk.CacheOnce) {
                NoiseChunk.CacheOnce typedWrapper = (NoiseChunk.CacheOnce)wrapper;
                typedWrapper.function = transformedChild;
            } else if (wrapper instanceof NoiseChunk.CacheAllInCell) {
                NoiseChunk.CacheAllInCell typedWrapper = (NoiseChunk.CacheAllInCell)wrapper;
                typedWrapper.noiseFiller = transformedChild;
            } else if (wrapper instanceof NoiseChunk.NoiseInterpolator) {
                NoiseChunk.NoiseInterpolator typedWrapper = (NoiseChunk.NoiseInterpolator)wrapper;
                typedWrapper.noiseFiller = transformedChild;
            } else if (wrapper instanceof NoiseChunk.FlatCache) {
                NoiseChunk.FlatCache typedWrapper = (NoiseChunk.FlatCache)wrapper;
                typedWrapper.noiseFiller = transformedChild;
            } else if (wrapper instanceof DensityFunctions.Marker) {
                DensityFunctions.Marker typedWrapper = (DensityFunctions.Marker)wrapper;
                typedWrapper.wrapped = transformedChild;
            }
        }
        return wrapper;
    }

    @Nullable
    private static DensityFunction transformPositional(DensityFunctions.TransformerWithContext positional) {
        DensityFunction originalChild = positional.input();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (positional instanceof DensityFunctions.BlendDensity) {
                DensityFunctions.BlendDensity typedPositional = (DensityFunctions.BlendDensity)positional;
                typedPositional.input = transformedChild;
            } else if (positional instanceof DensityFunctions.WeirdScaledSampler) {
                DensityFunctions.WeirdScaledSampler typedPositional = (DensityFunctions.WeirdScaledSampler)positional;
                typedPositional.input = transformedChild;
            }
        }
        return positional;
    }
}

