/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.myitian.no_caves.config.Config;
import org.jetbrains.annotations.Nullable;

public final class DensityFunctionCaveCleaner {
    private static final Map<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>> customTransformerRegistry = new LinkedHashMap<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>>();

    public static Map<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, @Nullable DensityFunction>>> getCustomTransformerRegistry() {
        return customTransformerRegistry;
    }

    @Nullable
    public static DensityFunction transform(DensityFunction original) {
        if (!customTransformerRegistry.isEmpty()) {
            for (Map.Entry<String, Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>>> entry : customTransformerRegistry.entrySet()) {
                String id = entry.getKey();
                try {
                    Tuple<Predicate<DensityFunction>, Function<DensityFunction, DensityFunction>> pair = entry.getValue();
                    if (pair == null || pair.m_14418_() == null || pair.m_14419_() == null || !((Predicate)pair.m_14418_()).test(original)) continue;
                    return (DensityFunction)((Function)pair.m_14419_()).apply(original);
                }
                catch (Exception e) {
                    throw new RuntimeException("An unhandled exception occurred in transformer " + id, e);
                }
            }
        } else {
            if (original instanceof DensityFunctions.HolderHolder) {
                DensityFunctions.HolderHolder holder = (DensityFunctions.HolderHolder)original;
                return DensityFunctionCaveCleaner.transformRegistryEntryHolder(holder);
            }
            if (original instanceof DensityFunctions.Noise) {
                DensityFunctions.Noise noise = (DensityFunctions.Noise)original;
                return DensityFunctionCaveCleaner.transformNoise(noise);
            }
            if (original instanceof DensityFunctions.RangeChoice) {
                DensityFunctions.RangeChoice rangeChoice = (DensityFunctions.RangeChoice)original;
                return DensityFunctionCaveCleaner.transformRangeChoice(rangeChoice);
            }
            if (original instanceof DensityFunctions.MulOrAdd) {
                DensityFunctions.MulOrAdd linear = (DensityFunctions.MulOrAdd)original;
                return DensityFunctionCaveCleaner.transformLinear(linear);
            }
            if (original instanceof DensityFunctions.TwoArgumentSimpleFunction) {
                DensityFunctions.TwoArgumentSimpleFunction binary = (DensityFunctions.TwoArgumentSimpleFunction)original;
                return DensityFunctionCaveCleaner.transformBinary(binary);
            }
            if (original instanceof DensityFunctions.PureTransformer) {
                DensityFunctions.PureTransformer unary = (DensityFunctions.PureTransformer)original;
                return DensityFunctionCaveCleaner.transformUnary(unary);
            }
            if (original instanceof DensityFunctions.MarkerOrMarked) {
                DensityFunctions.MarkerOrMarked wrapper = (DensityFunctions.MarkerOrMarked)original;
                return DensityFunctionCaveCleaner.transformWrapper(wrapper);
            }
            if (original instanceof DensityFunctions.TransformerWithContext) {
                DensityFunctions.TransformerWithContext positional = (DensityFunctions.TransformerWithContext)original;
                return DensityFunctionCaveCleaner.transformPositional(positional);
            }
        }
        return original;
    }

    public static boolean isCaveDensityFunction(DensityFunction densityFunction) {
        DensityFunctions.HolderHolder holder;
        return densityFunction instanceof DensityFunctions.HolderHolder && DensityFunctionCaveCleaner.isCaveDensityFunction((Holder<DensityFunction>)(holder = (DensityFunctions.HolderHolder)densityFunction).f_208636_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveDensityFunction(Holder<DensityFunction> densityFunction) {
        if (!(densityFunction instanceof Holder.Reference)) return false;
        Holder.Reference reference = (Holder.Reference)densityFunction;
        if (!Config.getDensityFunctionCavePatterns().matches(reference.m_205785_().m_135782_().toString())) return false;
        return true;
    }

    public static boolean isCaveNoise(DensityFunction.NoiseHolder noise) {
        return DensityFunctionCaveCleaner.isCaveNoise((Holder<NormalNoise.NoiseParameters>)noise.f_223997_());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveNoise(Holder<NormalNoise.NoiseParameters> noise) {
        if (!(noise instanceof Holder.Reference)) return false;
        Holder.Reference reference = (Holder.Reference)noise;
        if (!Config.getNoiseCavePatterns().matches(reference.m_205785_().m_135782_().toString())) return false;
        return true;
    }

    @Nullable
    public static DensityFunction transformRegistryEntryHolder(DensityFunctions.HolderHolder holder) {
        Holder function = holder.f_208636_();
        if (Config.isEnableDensityFunctionCaveFilter() && DensityFunctionCaveCleaner.isCaveDensityFunction((Holder<DensityFunction>)function)) {
            return null;
        }
        if (function instanceof Holder.Direct) {
            return DensityFunctionCaveCleaner.transform((DensityFunction)function.m_203334_());
        }
        return holder;
    }

    @Nullable
    public static DensityFunction transformNoise(DensityFunctions.Noise noise) {
        return Config.isEnableNoiseCaveFilter() && DensityFunctionCaveCleaner.isCaveNoise(noise.f_208787_()) ? null : noise;
    }

    @Nullable
    private static DensityFunction transformRangeChoice(DensityFunctions.RangeChoice rangeChoice) {
        DensityFunction input = rangeChoice.f_208823_();
        if (DensityFunctionCaveCleaner.isCaveDensityFunction(input)) {
            return DensityFunctionCaveCleaner.transform(rangeChoice.f_208827_());
        }
        if (input instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)input;
            double v = constant.f_208607_();
            if (v >= rangeChoice.f_208824_() && v < rangeChoice.f_208825_()) {
                return DensityFunctionCaveCleaner.transform(rangeChoice.f_208826_());
            }
            return DensityFunctionCaveCleaner.transform(rangeChoice.f_208827_());
        }
        DensityFunction originalChild1 = rangeChoice.f_208826_();
        DensityFunction transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        DensityFunction originalChild2 = rangeChoice.f_208827_();
        DensityFunction transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        rangeChoice.f_208826_ = transformedChild1;
        rangeChoice.f_208827_ = transformedChild2;
        return rangeChoice;
    }

    private static DensityFunction transformLinear(DensityFunctions.MulOrAdd linear) {
        DensityFunction originalChild = linear.m_207305_();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return DensityFunctions.m_208264_((double)linear.f_208750_());
        }
        if (transformedChild instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)transformedChild;
            return DensityFunctions.m_208264_((double)linear.m_207382_(constant.f_208607_()));
        }
        linear.f_208747_ = transformedChild;
        return linear;
    }

    @Nullable
    private static DensityFunction transformBinary(DensityFunctions.TwoArgumentSimpleFunction binary) {
        DensityFunction originalChild1 = binary.m_207185_();
        DensityFunction transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        DensityFunction originalChild2 = binary.m_207190_();
        DensityFunction transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        if (transformedChild1 instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant1 = (DensityFunctions.Constant)transformedChild1;
            if (transformedChild2 instanceof DensityFunctions.Constant) {
                DensityFunctions.Constant constant2 = (DensityFunctions.Constant)transformedChild2;
                double v1 = constant1.f_208607_();
                switch (binary.m_207119_()) {
                    case ADD: {
                        return DensityFunctions.m_208264_((double)(v1 + constant2.f_208607_()));
                    }
                    case MUL: {
                        return DensityFunctions.m_208264_((double)(v1 == 0.0 ? 0.0 : v1 * constant2.f_208607_()));
                    }
                    case MIN: {
                        return DensityFunctions.m_208264_((double)Math.min(v1, constant2.f_208607_()));
                    }
                    case MAX: {
                        return DensityFunctions.m_208264_((double)Math.max(v1, constant2.f_208607_()));
                    }
                }
            }
        }
        if (originalChild1 != transformedChild1 || originalChild2 != transformedChild2) {
            return DensityFunctions.TwoArgumentSimpleFunction.m_209073_((DensityFunctions.TwoArgumentSimpleFunction.Type)binary.m_207119_(), (DensityFunction)transformedChild1, (DensityFunction)transformedChild2);
        }
        return binary;
    }

    @Nullable
    private static DensityFunction transformUnary(DensityFunctions.PureTransformer unary) {
        DensityFunction originalChild = unary.m_207305_();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild instanceof DensityFunctions.Constant) {
            DensityFunctions.Constant constant = (DensityFunctions.Constant)transformedChild;
            return DensityFunctions.m_208264_((double)unary.m_207382_(constant.f_208607_()));
        }
        if (transformedChild != originalChild) {
            if (unary instanceof DensityFunctions.Clamp) {
                DensityFunctions.Clamp typedUnary = (DensityFunctions.Clamp)unary;
                typedUnary.f_208584_ = transformedChild;
            } else if (unary instanceof DensityFunctions.Mapped) {
                DensityFunctions.Mapped typedUnary = (DensityFunctions.Mapped)unary;
                return DensityFunctions.Mapped.m_208671_((DensityFunctions.Mapped.Type)typedUnary.f_208654_(), (DensityFunction)transformedChild);
            }
        }
        return unary;
    }

    @Nullable
    private static DensityFunction transformWrapper(DensityFunctions.MarkerOrMarked wrapper) {
        DensityFunction originalChild = wrapper.m_207056_();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (wrapper instanceof NoiseChunk.Cache2D) {
                NoiseChunk.Cache2D typedWrapper = (NoiseChunk.Cache2D)wrapper;
                typedWrapper.f_209284_ = transformedChild;
            } else if (wrapper instanceof NoiseChunk.Cache2D) {
                NoiseChunk.Cache2D typedWrapper = (NoiseChunk.Cache2D)wrapper;
                typedWrapper.f_209284_ = transformedChild;
            } else if (wrapper instanceof NoiseChunk.CacheOnce) {
                NoiseChunk.CacheOnce typedWrapper = (NoiseChunk.CacheOnce)wrapper;
                typedWrapper.f_209310_ = transformedChild;
            } else if (wrapper instanceof NoiseChunk.CacheAllInCell) {
                NoiseChunk.CacheAllInCell typedWrapper = (NoiseChunk.CacheAllInCell)wrapper;
                typedWrapper.f_209297_ = transformedChild;
            } else if (wrapper instanceof NoiseChunk.NoiseInterpolator) {
                NoiseChunk.NoiseInterpolator typedWrapper = (NoiseChunk.NoiseInterpolator)wrapper;
                typedWrapper.f_188830_ = transformedChild;
            } else if (wrapper instanceof NoiseChunk.FlatCache) {
                NoiseChunk.FlatCache typedWrapper = (NoiseChunk.FlatCache)wrapper;
                typedWrapper.f_209326_ = transformedChild;
            } else if (wrapper instanceof DensityFunctions.Marker) {
                DensityFunctions.Marker typedWrapper = (DensityFunctions.Marker)wrapper;
                typedWrapper.f_208706_ = transformedChild;
            }
        }
        return wrapper;
    }

    @Nullable
    private static DensityFunction transformPositional(DensityFunctions.TransformerWithContext positional) {
        DensityFunction originalChild = positional.m_207189_();
        DensityFunction transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (positional instanceof DensityFunctions.BlendDensity) {
                DensityFunctions.BlendDensity typedPositional = (DensityFunctions.BlendDensity)positional;
                typedPositional.f_208546_ = transformedChild;
            } else if (positional instanceof DensityFunctions.WeirdScaledSampler) {
                DensityFunctions.WeirdScaledSampler typedPositional = (DensityFunctions.WeirdScaledSampler)positional;
                typedPositional.f_208425_ = transformedChild;
            }
        }
        return positional;
    }
}

