/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.myitian.no_caves.DensityFunctionCaveCleaner;
import net.myitian.no_caves.NoCaves;
import net.myitian.no_caves.PatternSet;
import net.myitian.no_caves.config.Config;
import org.apache.commons.lang3.tuple.Pair;

public final class RegistryLoaderHelper {
    public static Object process(ResourceKey<?> key, Object rawValue) {
        ResourceLocation registryId;
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional) {
            Optional optional = (Optional)rawValue;
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        if ((registryId = key.m_211136_()).equals((Object)Registries.f_256932_.m_135782_())) {
            if (value instanceof NoiseGeneratorSettings) {
                NoiseGeneratorSettings checkedValue = (NoiseGeneratorSettings)value;
                RegistryLoaderHelper.processChunkGeneratorSettings(key.m_135782_(), checkedValue);
            }
        } else if (registryId.equals((Object)Registries.f_257040_.m_135782_())) {
            if (value instanceof DensityFunction) {
                DensityFunction checkedValue = (DensityFunction)value;
                value = RegistryLoaderHelper.processDensityFunction(key.m_135782_(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals((Object)Registries.f_256952_.m_135782_()) && value instanceof Biome) {
            Biome checkedValue = (Biome)value;
            RegistryLoaderHelper.processBiome(key.m_135782_(), checkedValue);
        }
        if (!newObject) {
            return rawValue;
        }
        if (useOptional) {
            return Optional.of(value);
        }
        return value;
    }

    public static void processChunkGeneratorSettings(ResourceLocation key, NoiseGeneratorSettings chunkGeneratorSettings) {
        if (!Config.isEnableFinalDensityTransformation() || Config.getFinalDensityTransformationExclusionPatterns().matches(key.toString())) {
            return;
        }
        NoiseRouter noiseRouter = chunkGeneratorSettings.f_209353_();
        DensityFunction finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.f_209391_());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn("Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.", (Object)key);
            finalDensity = DensityFunctions.m_208263_();
        }
        noiseRouter.f_209391_ = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}", (Object)(++NoCaves.transformedFinalDensity), (Object)key);
    }

    public static DensityFunction processDensityFunction(ResourceLocation key, DensityFunction densityFunction) {
        if (!Config.isEnableDensityFunctionTransformation() || !Config.getDensityFunctionToTransformPatterns().matches(key.toString())) {
            return densityFunction;
        }
        if ((densityFunction = DensityFunctionCaveCleaner.transform(densityFunction)) == null) {
            NoCaves.LOGGER.warn("Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.", (Object)key);
            densityFunction = DensityFunctions.m_208263_();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}", (Object)(++NoCaves.transformedDensityFunctions), (Object)key);
        return densityFunction;
    }

    public static void processBiome(ResourceLocation key, Biome biome) {
        if (!Config.isEnableCarverFilter() || Config.getCarverFilterBiomeExclusionPatterns().matches(key.toString())) {
            return;
        }
        BiomeGenerationSettings generationSettings = biome.m_47536_();
        PatternSet patterns = Config.getBiomeSpecificOverrideForDisabledCarverPatterns().getOrDefault(key.toString(), Config.getDisabledCarverPatterns());
        Pair[] carvers = new Pair[generationSettings.f_47780_.size()];
        int i = 0;
        for (Map.Entry entry : generationSettings.f_47780_.entrySet()) {
            HolderSet originalList = (HolderSet)entry.getValue();
            ArrayList<Holder> list = new ArrayList<Holder>(originalList.m_203632_());
            for (Holder regEntry : originalList) {
                Optional regKey = regEntry.m_203543_();
                if (!regKey.isPresent() || patterns.matches(((ResourceKey)regKey.get()).m_135782_().toString())) continue;
                list.add(regEntry);
            }
            carvers[i++] = Pair.of((Object)((GenerationStep.Carving)entry.getKey()), (Object)HolderSet.m_205800_(list));
        }
        generationSettings.f_47780_ = Map.ofEntries(carvers);
        NoCaves.LOGGER.debug("NoCaves.processedGenerationSettings {} {}", (Object)(++NoCaves.processedGenerationSettings), (Object)key);
    }
}

