/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.util.Tuple;
import net.myitian.no_caves.NoCaves;
import net.myitian.no_caves.PatternSet;
import net.myitian.no_caves.config.ConfigCodec;

public class Config {
    private static final ConfigCodec CODEC = new ConfigCodec();
    private static boolean enableCarverFilter = true;
    private static final PatternSet disabledCarverPatterns = new PatternSet(Pattern.compile("^minecraft:ca(?:nyon|ve(?:_extra_underground)?)$"), Pattern.compile("^biomesoplenty:origin_cave$"));
    private static final PatternSet carverFilterBiomeExclusionPatterns = new PatternSet();
    private static final LinkedHashMap<String, PatternSet> biomeSpecificOverrideForDisabledCarverPatterns = new LinkedHashMap();
    private static boolean enableDensityFunctionTransformation = true;
    private static final PatternSet densityFunctionToTransformPatterns = new PatternSet(Pattern.compile("^minecraft:overworld(?:_large_biomes)?/noise_router/final_density$"));
    private static boolean enableFinalDensityTransformation = true;
    private static final PatternSet finalDensityTransformationExclusionPatterns = new PatternSet();
    private static boolean enableNoiseCaveFilter = true;
    private static final PatternSet noiseCavePatterns = new PatternSet(Pattern.compile("^minecraft:cave_"));
    private static boolean enableDensityFunctionCaveFilter = true;
    private static final PatternSet densityFunctionCavePatterns = new PatternSet(Pattern.compile("^minecraft:overworld/caves/"), Pattern.compile("^tectonic:overworld/caves$"));

    public static boolean isEnableCarverFilter() {
        return enableCarverFilter;
    }

    public static void setEnableCarverFilter(boolean status) {
        enableCarverFilter = status;
    }

    public static PatternSet getDisabledCarverPatterns() {
        return disabledCarverPatterns;
    }

    public static PatternSet getCarverFilterBiomeExclusionPatterns() {
        return carverFilterBiomeExclusionPatterns;
    }

    public static Map<String, PatternSet> getBiomeSpecificOverrideForDisabledCarverPatterns() {
        return biomeSpecificOverrideForDisabledCarverPatterns;
    }

    public static boolean isEnableDensityFunctionTransformation() {
        return enableDensityFunctionTransformation;
    }

    public static void setEnableDensityFunctionTransformation(boolean status) {
        enableDensityFunctionTransformation = status;
    }

    public static PatternSet getDensityFunctionToTransformPatterns() {
        return densityFunctionToTransformPatterns;
    }

    public static boolean isEnableFinalDensityTransformation() {
        return enableFinalDensityTransformation;
    }

    public static void setEnableFinalDensityTransformation(boolean status) {
        enableFinalDensityTransformation = status;
    }

    public static PatternSet getFinalDensityTransformationExclusionPatterns() {
        return finalDensityTransformationExclusionPatterns;
    }

    public static boolean isEnableNoiseCaveFilter() {
        return enableNoiseCaveFilter;
    }

    public static void setEnableNoiseCaveFilter(boolean status) {
        enableNoiseCaveFilter = status;
    }

    public static PatternSet getNoiseCavePatterns() {
        return noiseCavePatterns;
    }

    public static boolean isEnableDensityFunctionCaveFilter() {
        return enableDensityFunctionCaveFilter;
    }

    public static void setEnableDensityFunctionCaveFilter(boolean status) {
        enableDensityFunctionCaveFilter = status;
    }

    public static PatternSet getDensityFunctionCavePatterns() {
        return densityFunctionCavePatterns;
    }

    public static boolean load(File configFile) {
        boolean bl;
        JsonReader reader = new JsonReader((Reader)new FileReader(configFile));
        try {
            reader.setLenient(true);
            bl = CODEC.deserialize(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                NoCaves.LOGGER.info("Failed to read config: {}", (Object)e.getLocalizedMessage());
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public static boolean save(File configFile) {
        boolean bl;
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));
        try {
            writer.setHtmlSafe(false);
            writer.setIndent("  ");
            bl = CODEC.serialize(writer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                NoCaves.LOGGER.warn("Failed to write config: {}", (Object)e.getLocalizedMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }

    static {
        Map<String, Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>> map = CODEC.getFieldMap();
        map.put("enableCarverFilter", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> Config.setEnableCarverFilter(reader.nextBoolean()), writer -> writer.value(Config.isEnableCarverFilter())));
        map.put("disabledCarverPatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getDisabledCarverPatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getDisabledCarverPatterns())));
        map.put("carverFilterBiomeExclusionPatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getCarverFilterBiomeExclusionPatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getCarverFilterBiomeExclusionPatterns())));
        map.put("biomeSpecificOverrideForDisabledCarverPatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readString2PatternSetMap(reader, Config.getBiomeSpecificOverrideForDisabledCarverPatterns(), true), writer -> ConfigCodec.writeString2PatternSetMap(writer, Config.getBiomeSpecificOverrideForDisabledCarverPatterns())));
        map.put("enableDensityFunctionTransformation", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> Config.setEnableDensityFunctionTransformation(reader.nextBoolean()), writer -> writer.value(Config.isEnableDensityFunctionTransformation())));
        map.put("densityFunctionToTransformPatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getDensityFunctionToTransformPatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getDensityFunctionToTransformPatterns())));
        map.put("enableFinalDensityTransformation", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> Config.setEnableFinalDensityTransformation(reader.nextBoolean()), writer -> writer.value(Config.isEnableFinalDensityTransformation())));
        map.put("finalDensityTransformationExclusionPatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getFinalDensityTransformationExclusionPatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getFinalDensityTransformationExclusionPatterns())));
        map.put("enableNoiseCaveFilter", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> Config.setEnableNoiseCaveFilter(reader.nextBoolean()), writer -> writer.value(Config.isEnableNoiseCaveFilter())));
        map.put("noiseCavePatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getNoiseCavePatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getNoiseCavePatterns())));
        map.put("enableDensityFunctionCaveFilter", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> Config.setEnableDensityFunctionCaveFilter(reader.nextBoolean()), writer -> writer.value(Config.isEnableDensityFunctionCaveFilter())));
        map.put("densityFunctionCavePatterns", (Tuple<ConfigCodec.ConsumerWithIOException<JsonReader>, ConfigCodec.ConsumerWithIOException<JsonWriter>>)new Tuple(reader -> ConfigCodec.readPatternSet(reader, Config.getDensityFunctionCavePatterns(), true), writer -> ConfigCodec.writePatternSet(writer, Config.getDensityFunctionCavePatterns())));
    }
}

