package net.myitian.no_caves;

import net.minecraft.class_3545;
import net.minecraft.class_5216;
import net.minecraft.class_6568;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.myitian.no_caves.config.Config;
import org.jetbrains.annotations.Nullable;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Function;
import java.util.function.Predicate;

public final class DensityFunctionCaveCleaner {
    private static final Map<String, class_3545<Predicate<class_6910>, Function<class_6910, class_6910>>> customTransformerRegistry = new LinkedHashMap<>();

    /**
     * @return a mutable map that preserves insertion order
     */
    public static Map<String, class_3545<Predicate<class_6910>, Function<class_6910, @Nullable class_6910>>> getCustomTransformerRegistry() {
        return customTransformerRegistry;
    }

    /**
     * @return null if the original DensityFunction is a cave DensityFunction,
     * otherwise the original DensityFunction will be transformed and returned.
     * @apiNote Some in-place transformations will be done, so the original DensityFunction may change!
     */
    @Nullable
    public static class_6910 transform(class_6910 original) {
        if (!customTransformerRegistry.isEmpty()) {
            for (var entry : customTransformerRegistry.entrySet()) {
                String id = entry.getKey();
                try {
                    var pair = entry.getValue();
                    if (pair != null
                            && pair.method_15442() != null
                            && pair.method_15441() != null
                            && pair.method_15442().test(original)) {
                        return pair.method_15441().apply(original);
                    }
                } catch (Exception e) {
                    throw new RuntimeException("An unhandled exception occurred in transformer " + id, e);
                }
            }
        } else if (original instanceof class_6916.class_7051 holder) {
            return transformRegistryEntryHolder(holder);
        } else if (original instanceof class_6916.class_6931 noise) {
            return transformNoise(noise);
        } else if (original instanceof class_6916.class_6933 rangeChoice) {
            return transformRangeChoice(rangeChoice);
        } else if (original instanceof class_6916.class_6929 linear) {
            return transformLinear(linear);
        } else if (original instanceof class_6916.class_7055 binary) {
            return transformBinary(binary);
        } else if (original instanceof class_6916.class_6932 unary) {
            return transformUnary(unary);
        } else if (original instanceof class_6916.class_7052 wrapper) {
            return transformWrapper(wrapper);
        } else if (original instanceof class_6916.class_6943 positional) {
            return transformPositional(positional);
        }
        return original;
    }

    public static boolean isCaveDensityFunction(class_6910 densityFunction) {
        return densityFunction instanceof class_6916.class_7051 holder
                && isCaveDensityFunction(holder.comp_468());
    }

    public static boolean isCaveDensityFunction(class_6880<class_6910> densityFunction) {
        return densityFunction instanceof class_6880.class_6883<class_6910> reference
                && Config.getDensityFunctionCavePatterns().matches(reference.method_40237().method_29177().toString());
    }

    public static boolean isCaveNoise(class_6910.class_7270 noise) {
        return isCaveNoise(noise.comp_662());
    }

    public static boolean isCaveNoise(class_6880<class_5216.class_5487> noise) {
        return noise instanceof class_6880.class_6883<class_5216.class_5487> reference
                && Config.getNoiseCavePatterns().matches(reference.method_40237().method_29177().toString());
    }

    @Nullable
    public static class_6910 transformRegistryEntryHolder(class_6916.class_7051 holder) {
        class_6880<class_6910> function = holder.comp_468();
        if (Config.isEnableDensityFunctionCaveFilter() && isCaveDensityFunction(function)) {
            return null;
        } else if (function instanceof class_6880.class_6881<class_6910>) {
            return transform(function.comp_349());
        }
        return holder;
    }

    @Nullable
    public static class_6910 transformNoise(class_6916.class_6931 noise) {
        return Config.isEnableNoiseCaveFilter() && isCaveNoise(noise.comp_387()) ? null : noise;
    }

    @Nullable
    private static class_6910 transformRangeChoice(class_6916.class_6933 rangeChoice) {
        class_6910 input = rangeChoice.comp_390();
        if (isCaveDensityFunction(input)) {
            // Might not cover all cases, but good enough for vanilla worldgen json.
            return transform(rangeChoice.comp_394());
        } else if (input instanceof class_6916.class_6923 constant) {
            double v = constant.comp_381();
            if (v >= rangeChoice.comp_391() && v < rangeChoice.comp_392()) {
                return transform(rangeChoice.comp_393());
            } else {
                return transform(rangeChoice.comp_394());
            }
        } else {
            class_6910 originalChild1 = rangeChoice.comp_393();
            class_6910 transformedChild1 = transform(originalChild1);
            class_6910 originalChild2 = rangeChoice.comp_394();
            class_6910 transformedChild2 = transform(originalChild2);
            if (transformedChild1 == null) {
                return transformedChild2;
            } else if (transformedChild2 == null) {
                return transformedChild1;
            } else {
                rangeChoice.comp_393 = transformedChild1;
                rangeChoice.comp_394 = transformedChild2;
                return rangeChoice;
            }
        }
    }

    private static class_6910 transformLinear(class_6916.class_6929 linear) {
        class_6910 originalChild = linear.comp_380();
        class_6910 transformedChild = transform(originalChild);
        if (transformedChild == null) {
            return class_6916.method_40480(linear.comp_386());
        } else if (transformedChild instanceof class_6916.class_6923 constant) {
            return class_6916.method_40480(linear.method_40520(constant.comp_381()));
        } else {
            linear.comp_380 = transformedChild;
            return linear;
        }
    }

    @Nullable
    private static class_6910 transformBinary(class_6916.class_7055 binary) {
        class_6910 originalChild1 = binary.comp_375();
        class_6910 transformedChild1 = transform(originalChild1);
        class_6910 originalChild2 = binary.comp_376();
        class_6910 transformedChild2 = transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        } else if (transformedChild2 == null) {
            return transformedChild1;
        } else if (transformedChild1 instanceof class_6916.class_6923 constant1
                && transformedChild2 instanceof class_6916.class_6923 constant2) {
            double v1 = constant1.comp_381();
            switch (binary.comp_374()) {
                case field_36544 -> {
                    return class_6916.method_40480(v1 + constant2.comp_381());
                }
                case field_36545 -> {
                    return class_6916.method_40480(v1 == 0.0 ? 0.0 : v1 * constant2.comp_381());
                }
                case field_36546 -> {
                    return class_6916.method_40480(Math.min(v1, constant2.comp_381()));
                }
                case field_36547 -> {
                    return class_6916.method_40480(Math.max(v1, constant2.comp_381()));
                }
                default -> {
                }
            }
        }
        if (originalChild1 != transformedChild1 || originalChild2 != transformedChild2) {
            return class_6916.class_7055.method_41097(binary.comp_374(), transformedChild1, transformedChild2);
        }
        return binary;
    }

    @Nullable
    private static class_6910 transformUnary(class_6916.class_6932 unary) {
        class_6910 originalChild = unary.comp_380();
        class_6910 transformedChild = transform(originalChild);
        if (transformedChild == null) {
            return null;
        } else if (transformedChild instanceof class_6916.class_6923 constant) {
            return class_6916.method_40480(unary.method_40520(constant.comp_381()));
        } else if (transformedChild != originalChild) {
            if (unary instanceof class_6916.class_6922 typedUnary) {
                typedUnary.comp_380 = transformedChild;
            } else if (unary instanceof class_6916.class_6925 typedUnary) {
                return class_6916.class_6925.method_41079(typedUnary.comp_382(), transformedChild);
            }
            // Unknown types will be left as is
        }
        return unary;
    }

    @Nullable
    private static class_6910 transformWrapper(class_6916.class_7052 wrapper) {
        class_6910 originalChild = wrapper.comp_469();
        class_6910 transformedChild = transform(originalChild);
        if (transformedChild == null) {
            return null;
        } else if (transformedChild != originalChild) {
            if (wrapper instanceof class_6568.class_6948 typedWrapper) {
                typedWrapper.field_36599 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6948 typedWrapper) {
                typedWrapper.field_36599 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6950 typedWrapper) {
                typedWrapper.field_36606 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6949 typedWrapper) {
                typedWrapper.field_36603 = transformedChild;
            } else if (wrapper instanceof class_6568.class_5917 typedWrapper) {
                typedWrapper.field_34623 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6951 typedWrapper) {
                typedWrapper.field_36612 = transformedChild;
            } else if (wrapper instanceof class_6916.class_6927 typedWrapper) {
                typedWrapper.comp_469 = transformedChild;
            }
            // Unknown types will be left as is
        }
        return wrapper;
    }

    @Nullable
    private static class_6910 transformPositional(class_6916.class_6943 positional) {
        class_6910 originalChild = positional.comp_379();
        class_6910 transformedChild = transform(originalChild);
        if (transformedChild == null) {
            return null;
        } else if (transformedChild != originalChild) {
            if (positional instanceof class_6916.class_6920 typedPositional) {
                typedPositional.comp_379 = transformedChild;
            } else if (positional instanceof class_6916.class_6944 typedPositional) {
                typedPositional.comp_379 = transformedChild;
            }
            // Unknown types will be left as is
        }
        return positional;
    }
}
