/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_3545;
import net.minecraft.class_5216;
import net.minecraft.class_6568;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.myitian.no_caves.config.Config;
import org.jetbrains.annotations.Nullable;

public final class DensityFunctionCaveCleaner {
    private static final Map<String, class_3545<Predicate<class_6910>, Function<class_6910, class_6910>>> customTransformerRegistry = new LinkedHashMap<String, class_3545<Predicate<class_6910>, Function<class_6910, class_6910>>>();

    public static Map<String, class_3545<Predicate<class_6910>, Function<class_6910, @Nullable class_6910>>> getCustomTransformerRegistry() {
        return customTransformerRegistry;
    }

    @Nullable
    public static class_6910 transform(class_6910 original) {
        if (!customTransformerRegistry.isEmpty()) {
            for (Map.Entry<String, class_3545<Predicate<class_6910>, Function<class_6910, class_6910>>> entry : customTransformerRegistry.entrySet()) {
                String id = entry.getKey();
                try {
                    class_3545<Predicate<class_6910>, Function<class_6910, class_6910>> pair = entry.getValue();
                    if (pair == null || pair.method_15442() == null || pair.method_15441() == null || !((Predicate)pair.method_15442()).test(original)) continue;
                    return (class_6910)((Function)pair.method_15441()).apply(original);
                }
                catch (Exception e) {
                    throw new RuntimeException("An unhandled exception occurred in transformer " + id, e);
                }
            }
        } else {
            if (original instanceof class_6916.class_7051) {
                class_6916.class_7051 holder = (class_6916.class_7051)original;
                return DensityFunctionCaveCleaner.transformRegistryEntryHolder(holder);
            }
            if (original instanceof class_6916.class_6931) {
                class_6916.class_6931 noise = (class_6916.class_6931)original;
                return DensityFunctionCaveCleaner.transformNoise(noise);
            }
            if (original instanceof class_6916.class_6933) {
                class_6916.class_6933 rangeChoice = (class_6916.class_6933)original;
                return DensityFunctionCaveCleaner.transformRangeChoice(rangeChoice);
            }
            if (original instanceof class_6916.class_6929) {
                class_6916.class_6929 linear = (class_6916.class_6929)original;
                return DensityFunctionCaveCleaner.transformLinear(linear);
            }
            if (original instanceof class_6916.class_7055) {
                class_6916.class_7055 binary = (class_6916.class_7055)original;
                return DensityFunctionCaveCleaner.transformBinary(binary);
            }
            if (original instanceof class_6916.class_6932) {
                class_6916.class_6932 unary = (class_6916.class_6932)original;
                return DensityFunctionCaveCleaner.transformUnary(unary);
            }
            if (original instanceof class_6916.class_7052) {
                class_6916.class_7052 wrapper = (class_6916.class_7052)original;
                return DensityFunctionCaveCleaner.transformWrapper(wrapper);
            }
            if (original instanceof class_6916.class_6943) {
                class_6916.class_6943 positional = (class_6916.class_6943)original;
                return DensityFunctionCaveCleaner.transformPositional(positional);
            }
        }
        return original;
    }

    public static boolean isCaveDensityFunction(class_6910 densityFunction) {
        class_6916.class_7051 holder;
        return densityFunction instanceof class_6916.class_7051 && DensityFunctionCaveCleaner.isCaveDensityFunction((class_6880<class_6910>)(holder = (class_6916.class_7051)densityFunction).comp_468());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveDensityFunction(class_6880<class_6910> densityFunction) {
        if (!(densityFunction instanceof class_6880.class_6883)) return false;
        class_6880.class_6883 reference = (class_6880.class_6883)densityFunction;
        if (!Config.getDensityFunctionCavePatterns().matches(reference.method_40237().method_29177().toString())) return false;
        return true;
    }

    public static boolean isCaveNoise(class_6910.class_7270 noise) {
        return DensityFunctionCaveCleaner.isCaveNoise((class_6880<class_5216.class_5487>)noise.comp_662());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCaveNoise(class_6880<class_5216.class_5487> noise) {
        if (!(noise instanceof class_6880.class_6883)) return false;
        class_6880.class_6883 reference = (class_6880.class_6883)noise;
        if (!Config.getNoiseCavePatterns().matches(reference.method_40237().method_29177().toString())) return false;
        return true;
    }

    @Nullable
    public static class_6910 transformRegistryEntryHolder(class_6916.class_7051 holder) {
        class_6880 function = holder.comp_468();
        if (Config.isEnableDensityFunctionCaveFilter() && DensityFunctionCaveCleaner.isCaveDensityFunction((class_6880<class_6910>)function)) {
            return null;
        }
        if (function instanceof class_6880.class_6881) {
            return DensityFunctionCaveCleaner.transform((class_6910)function.comp_349());
        }
        return holder;
    }

    @Nullable
    public static class_6910 transformNoise(class_6916.class_6931 noise) {
        return Config.isEnableNoiseCaveFilter() && DensityFunctionCaveCleaner.isCaveNoise(noise.comp_387()) ? null : noise;
    }

    @Nullable
    private static class_6910 transformRangeChoice(class_6916.class_6933 rangeChoice) {
        class_6910 input = rangeChoice.comp_390();
        if (DensityFunctionCaveCleaner.isCaveDensityFunction(input)) {
            return DensityFunctionCaveCleaner.transform(rangeChoice.comp_394());
        }
        if (input instanceof class_6916.class_6923) {
            class_6916.class_6923 constant = (class_6916.class_6923)input;
            double v = constant.comp_381();
            if (v >= rangeChoice.comp_391() && v < rangeChoice.comp_392()) {
                return DensityFunctionCaveCleaner.transform(rangeChoice.comp_393());
            }
            return DensityFunctionCaveCleaner.transform(rangeChoice.comp_394());
        }
        class_6910 originalChild1 = rangeChoice.comp_393();
        class_6910 transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        class_6910 originalChild2 = rangeChoice.comp_394();
        class_6910 transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        rangeChoice.comp_393 = transformedChild1;
        rangeChoice.comp_394 = transformedChild2;
        return rangeChoice;
    }

    private static class_6910 transformLinear(class_6916.class_6929 linear) {
        class_6910 originalChild = linear.comp_380();
        class_6910 transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return class_6916.method_40480((double)linear.comp_386());
        }
        if (transformedChild instanceof class_6916.class_6923) {
            class_6916.class_6923 constant = (class_6916.class_6923)transformedChild;
            return class_6916.method_40480((double)linear.method_40520(constant.comp_381()));
        }
        linear.comp_380 = transformedChild;
        return linear;
    }

    @Nullable
    private static class_6910 transformBinary(class_6916.class_7055 binary) {
        class_6910 originalChild1 = binary.comp_375();
        class_6910 transformedChild1 = DensityFunctionCaveCleaner.transform(originalChild1);
        class_6910 originalChild2 = binary.comp_376();
        class_6910 transformedChild2 = DensityFunctionCaveCleaner.transform(originalChild2);
        if (transformedChild1 == null) {
            return transformedChild2;
        }
        if (transformedChild2 == null) {
            return transformedChild1;
        }
        if (transformedChild1 instanceof class_6916.class_6923) {
            class_6916.class_6923 constant1 = (class_6916.class_6923)transformedChild1;
            if (transformedChild2 instanceof class_6916.class_6923) {
                class_6916.class_6923 constant2 = (class_6916.class_6923)transformedChild2;
                double v1 = constant1.comp_381();
                switch (binary.comp_374()) {
                    case field_36544: {
                        return class_6916.method_40480((double)(v1 + constant2.comp_381()));
                    }
                    case field_36545: {
                        return class_6916.method_40480((double)(v1 == 0.0 ? 0.0 : v1 * constant2.comp_381()));
                    }
                    case field_36546: {
                        return class_6916.method_40480((double)Math.min(v1, constant2.comp_381()));
                    }
                    case field_36547: {
                        return class_6916.method_40480((double)Math.max(v1, constant2.comp_381()));
                    }
                }
            }
        }
        if (originalChild1 != transformedChild1 || originalChild2 != transformedChild2) {
            return class_6916.class_7055.method_41097((class_6916.class_7055.class_6918)binary.comp_374(), (class_6910)transformedChild1, (class_6910)transformedChild2);
        }
        return binary;
    }

    @Nullable
    private static class_6910 transformUnary(class_6916.class_6932 unary) {
        class_6910 originalChild = unary.comp_380();
        class_6910 transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild instanceof class_6916.class_6923) {
            class_6916.class_6923 constant = (class_6916.class_6923)transformedChild;
            return class_6916.method_40480((double)unary.method_40520(constant.comp_381()));
        }
        if (transformedChild != originalChild) {
            if (unary instanceof class_6916.class_6922) {
                class_6916.class_6922 typedUnary = (class_6916.class_6922)unary;
                typedUnary.comp_380 = transformedChild;
            } else if (unary instanceof class_6916.class_6925) {
                class_6916.class_6925 typedUnary = (class_6916.class_6925)unary;
                return class_6916.class_6925.method_41079((class_6916.class_6925.class_6926)typedUnary.comp_382(), (class_6910)transformedChild);
            }
        }
        return unary;
    }

    @Nullable
    private static class_6910 transformWrapper(class_6916.class_7052 wrapper) {
        class_6910 originalChild = wrapper.comp_469();
        class_6910 transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (wrapper instanceof class_6568.class_6948) {
                class_6568.class_6948 typedWrapper = (class_6568.class_6948)wrapper;
                typedWrapper.field_36599 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6948) {
                class_6568.class_6948 typedWrapper = (class_6568.class_6948)wrapper;
                typedWrapper.field_36599 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6950) {
                class_6568.class_6950 typedWrapper = (class_6568.class_6950)wrapper;
                typedWrapper.field_36606 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6949) {
                class_6568.class_6949 typedWrapper = (class_6568.class_6949)wrapper;
                typedWrapper.field_36603 = transformedChild;
            } else if (wrapper instanceof class_6568.class_5917) {
                class_6568.class_5917 typedWrapper = (class_6568.class_5917)wrapper;
                typedWrapper.field_34623 = transformedChild;
            } else if (wrapper instanceof class_6568.class_6951) {
                class_6568.class_6951 typedWrapper = (class_6568.class_6951)wrapper;
                typedWrapper.field_36612 = transformedChild;
            } else if (wrapper instanceof class_6916.class_6927) {
                class_6916.class_6927 typedWrapper = (class_6916.class_6927)wrapper;
                typedWrapper.comp_469 = transformedChild;
            }
        }
        return wrapper;
    }

    @Nullable
    private static class_6910 transformPositional(class_6916.class_6943 positional) {
        class_6910 originalChild = positional.comp_379();
        class_6910 transformedChild = DensityFunctionCaveCleaner.transform(originalChild);
        if (transformedChild == null) {
            return null;
        }
        if (transformedChild != originalChild) {
            if (positional instanceof class_6916.class_6920) {
                class_6916.class_6920 typedPositional = (class_6916.class_6920)positional;
                typedPositional.comp_379 = transformedChild;
            } else if (positional instanceof class_6916.class_6944) {
                class_6916.class_6944 typedPositional = (class_6916.class_6944)positional;
                typedPositional.comp_379 = transformedChild;
            }
        }
        return positional;
    }
}

