/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5485;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7924;
import net.myitian.no_caves.DensityFunctionCaveCleaner;
import net.myitian.no_caves.NoCaves;
import net.myitian.no_caves.PatternSet;
import net.myitian.no_caves.config.Config;
import org.apache.commons.lang3.tuple.Pair;

public final class RegistryLoaderHelper {
    public static Object process(class_5321<?> key, Object rawValue) {
        class_2960 registryId;
        boolean newObject = false;
        boolean useOptional = false;
        Object value = rawValue;
        if (rawValue instanceof Optional) {
            Optional optional = (Optional)rawValue;
            if (optional.isEmpty()) {
                return rawValue;
            }
            value = optional.get();
            useOptional = true;
        }
        if ((registryId = key.method_41185()).equals((Object)class_7924.field_41243.method_29177())) {
            if (value instanceof class_5284) {
                class_5284 checkedValue = (class_5284)value;
                RegistryLoaderHelper.processChunkGeneratorSettings(key.method_29177(), checkedValue);
            }
        } else if (registryId.equals((Object)class_7924.field_41240.method_29177())) {
            if (value instanceof class_6910) {
                class_6910 checkedValue = (class_6910)value;
                value = RegistryLoaderHelper.processDensityFunction(key.method_29177(), checkedValue);
                newObject = true;
            }
        } else if (registryId.equals((Object)class_7924.field_41236.method_29177()) && value instanceof class_1959) {
            class_1959 checkedValue = (class_1959)value;
            RegistryLoaderHelper.processBiome(key.method_29177(), checkedValue);
        }
        if (!newObject) {
            return rawValue;
        }
        if (useOptional) {
            return Optional.of(value);
        }
        return value;
    }

    public static void processChunkGeneratorSettings(class_2960 key, class_5284 chunkGeneratorSettings) {
        if (!Config.isEnableFinalDensityTransformation() || Config.getFinalDensityTransformationExclusionPatterns().matches(key.toString())) {
            return;
        }
        class_6953 noiseRouter = chunkGeneratorSettings.comp_477();
        class_6910 finalDensity = DensityFunctionCaveCleaner.transform(noiseRouter.comp_487());
        if (finalDensity == null) {
            NoCaves.LOGGER.warn("Null FinalDensity detected in {}. This shouldn't happen unless there are worlds that only use cave noise functions.", (Object)key);
            finalDensity = class_6916.method_40479();
        }
        noiseRouter.comp_487 = finalDensity;
        NoCaves.LOGGER.debug("NoCaves.transformedFinalDensity {} {}", (Object)(++NoCaves.transformedFinalDensity), (Object)key);
    }

    public static class_6910 processDensityFunction(class_2960 key, class_6910 densityFunction) {
        if (!Config.isEnableDensityFunctionTransformation() || !Config.getDensityFunctionToTransformPatterns().matches(key.toString())) {
            return densityFunction;
        }
        if ((densityFunction = DensityFunctionCaveCleaner.transform(densityFunction)) == null) {
            NoCaves.LOGGER.warn("Null DensityFunction detected in {}. Consider adding this function to densityFunctionCavePatterns, otherwise it may negatively impact world generation.", (Object)key);
            densityFunction = class_6916.method_40479();
        }
        NoCaves.LOGGER.debug("NoCaves.transformedDensityFunctions {} {}", (Object)(++NoCaves.transformedDensityFunctions), (Object)key);
        return densityFunction;
    }

    public static void processBiome(class_2960 key, class_1959 biome) {
        if (!Config.isEnableCarverFilter() || Config.getCarverFilterBiomeExclusionPatterns().matches(key.toString())) {
            return;
        }
        class_5485 generationSettings = biome.method_30970();
        PatternSet patterns = Config.getBiomeSpecificOverrideForDisabledCarverPatterns().getOrDefault(key.toString(), Config.getDisabledCarverPatterns());
        Pair[] carvers = new Pair[generationSettings.field_26415.size()];
        int i = 0;
        for (Map.Entry entry : generationSettings.field_26415.entrySet()) {
            class_6885 originalList = (class_6885)entry.getValue();
            ArrayList<class_6880> list = new ArrayList<class_6880>(originalList.method_40247());
            for (class_6880 regEntry : originalList) {
                Optional regKey = regEntry.method_40230();
                if (!regKey.isPresent() || patterns.matches(((class_5321)regKey.get()).method_29177().toString())) continue;
                list.add(regEntry);
            }
            carvers[i++] = Pair.of((Object)((class_2893.class_2894)entry.getKey()), (Object)class_6885.method_40242(list));
        }
        generationSettings.field_26415 = Map.ofEntries(carvers);
        NoCaves.LOGGER.debug("NoCaves.processedGenerationSettings {} {}", (Object)(++NoCaves.processedGenerationSettings), (Object)key);
    }
}

