/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_3545;
import net.myitian.no_caves.PatternSet;
import org.jetbrains.annotations.Nullable;

public class ConfigCodec {
    private final LinkedHashMap<String, class_3545<ConsumerWithIOException<JsonReader>, ConsumerWithIOException<JsonWriter>>> fieldMap = new LinkedHashMap();

    @Nullable
    public static Pattern readPattern(JsonReader reader) throws IOException {
        String pattern = null;
        int flags = 0;
        block0 : switch (reader.peek()) {
            case STRING: {
                pattern = reader.nextString();
                break;
            }
            case BEGIN_ARRAY: {
                reader.beginArray();
                block24: while (true) {
                    switch (reader.peek()) {
                        case END_ARRAY: {
                            reader.endArray();
                            break block0;
                        }
                        case END_DOCUMENT: {
                            break block0;
                        }
                        case STRING: {
                            pattern = reader.nextString();
                            continue block24;
                        }
                        case NUMBER: {
                            flags = reader.nextInt();
                            continue block24;
                        }
                    }
                    reader.skipValue();
                }
            }
            case BEGIN_OBJECT: {
                reader.beginObject();
                block25: while (true) {
                    switch (reader.peek()) {
                        case END_OBJECT: {
                            reader.endObject();
                            break block0;
                        }
                        case END_DOCUMENT: {
                            break block0;
                        }
                        case NAME: {
                            switch (reader.nextName()) {
                                case "pattern": {
                                    pattern = reader.nextString();
                                    break;
                                }
                                case "flags": {
                                    flags = reader.nextInt();
                                }
                            }
                            continue block25;
                        }
                    }
                    reader.skipValue();
                }
            }
        }
        return pattern == null ? null : Pattern.compile(pattern, flags);
    }

    public static void writePattern(JsonWriter writer, @Nullable Pattern pattern) throws IOException {
        if (pattern == null) {
            writer.nullValue();
        } else if (pattern.flags() == 0) {
            writer.value(pattern.pattern());
        } else {
            writer.beginArray();
            writer.value(pattern.pattern());
            writer.value((long)pattern.flags());
            writer.endArray();
        }
    }

    public static void readPatternSet(JsonReader reader, Set<Pattern> set, boolean clearBeforeAdd) throws IOException {
        reader.beginArray();
        if (clearBeforeAdd) {
            set.clear();
        }
        while (true) {
            switch (reader.peek()) {
                case END_ARRAY: {
                    reader.endArray();
                    return;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
            Pattern p = ConfigCodec.readPattern(reader);
            if (p == null) continue;
            set.add(p);
        }
    }

    public static void writePatternSet(JsonWriter writer, Set<Pattern> set) throws IOException {
        writer.beginArray();
        for (Pattern p : set) {
            if (p == null) continue;
            ConfigCodec.writePattern(writer, p);
        }
        writer.endArray();
    }

    public static void readString2PatternSetMap(JsonReader reader, Map<String, PatternSet> map, boolean clearBeforeAdd) throws IOException {
        reader.beginObject();
        if (clearBeforeAdd) {
            map.clear();
        }
        PatternSet set = null;
        block6: while (true) {
            switch (reader.peek()) {
                case END_OBJECT: {
                    reader.endObject();
                    return;
                }
                case END_DOCUMENT: {
                    return;
                }
                case NAME: {
                    String key = reader.nextName();
                    set = map.get(key);
                    if (set != null) continue block6;
                    set = new PatternSet();
                    map.put(key, set);
                    continue block6;
                }
                case STRING: {
                    assert (set != null);
                    set.add(Pattern.compile(reader.nextString()));
                    continue block6;
                }
            }
            assert (set != null);
            ConfigCodec.readPatternSet(reader, set, false);
        }
    }

    public static void writeString2PatternSetMap(JsonWriter writer, Map<String, PatternSet> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, PatternSet> e : map.entrySet()) {
            writer.name(e.getKey());
            ConfigCodec.writePatternSet(writer, e.getValue());
        }
        writer.endObject();
    }

    public Map<String, class_3545<ConsumerWithIOException<JsonReader>, ConsumerWithIOException<JsonWriter>>> getFieldMap() {
        return this.fieldMap;
    }

    public boolean deserialize(JsonReader reader) throws IOException {
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            return false;
        }
        reader.beginObject();
        HashSet<String> nameSet = new HashSet<String>(this.fieldMap.size());
        while (reader.peek() == JsonToken.NAME) {
            String name = reader.nextName();
            class_3545<ConsumerWithIOException<JsonReader>, ConsumerWithIOException<JsonWriter>> pair = this.fieldMap.get(name);
            if (pair != null) {
                nameSet.add(name);
                ((ConsumerWithIOException)pair.method_15442()).accept(reader);
                continue;
            }
            reader.skipValue();
        }
        return nameSet.size() == this.fieldMap.size();
    }

    public boolean serialize(JsonWriter writer) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, class_3545<ConsumerWithIOException<JsonReader>, ConsumerWithIOException<JsonWriter>>> fieldInfo : this.fieldMap.entrySet()) {
            writer.name(fieldInfo.getKey());
            ((ConsumerWithIOException)fieldInfo.getValue().method_15441()).accept(writer);
        }
        writer.endObject();
        return true;
    }

    @FunctionalInterface
    public static interface ConsumerWithIOException<T> {
        public void accept(T var1) throws IOException;
    }
}

