/*
 * Decompiled with CFR 0.152.
 */
package net.myitian.no_caves;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Set;
import java.util.regex.Pattern;
import net.myitian.no_caves.DensityFunctionCaveCleaner;
import net.myitian.no_caves.PatternSet;
import net.myitian.no_caves.PlatformUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NoCaves {
    public static final String MOD_ID = "no_caves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"no_caves");
    private static final Path configPath = PlatformUtil.getConfigDirectory().resolve("no_caves.json");
    private static boolean enableCarverFilter = true;
    private static final PatternSet disabledCarverPatterns = new PatternSet(Pattern.compile("^minecraft:ca(?:nyon|ve(?:_extra_underground)?)$"));
    private static final PatternSet carverFilterBiomeExclusionPatterns = new PatternSet();
    private static boolean enableDensityFunctionTransformation = true;
    private static final PatternSet densityFunctionToTransformPatterns = new PatternSet(Pattern.compile("^minecraft:overworld(?:_large_biomes)?/noise_router/final_density$"));
    private static boolean enableFinalDensityTransformation = true;
    private static final PatternSet finalDensityTransformationExclusionPatterns = new PatternSet();
    public static int processedGenerationSettings = 0;
    public static int transformedFinalDensity = 0;
    public static int transformedDensityFunctions = 0;

    public static Path getConfigPath() {
        return configPath;
    }

    public static boolean isEnableCarverFilter() {
        return enableCarverFilter;
    }

    public static void setEnableCarverFilter(boolean status) {
        enableCarverFilter = status;
    }

    public static PatternSet getDisabledCarverPatterns() {
        return disabledCarverPatterns;
    }

    public static PatternSet getCarverFilterBiomeExclusionPatterns() {
        return carverFilterBiomeExclusionPatterns;
    }

    public static boolean isEnableDensityFunctionTransformation() {
        return enableDensityFunctionTransformation;
    }

    public static void setEnableDensityFunctionTransformation(boolean status) {
        enableDensityFunctionTransformation = status;
    }

    public static PatternSet getDensityFunctionToTransformPatterns() {
        return densityFunctionToTransformPatterns;
    }

    public static boolean isEnableFinalDensityTransformation() {
        return enableFinalDensityTransformation;
    }

    public static void setEnableFinalDensityTransformation(boolean status) {
        enableFinalDensityTransformation = status;
    }

    public static PatternSet getFinalDensityTransformationExclusionPatterns() {
        return finalDensityTransformationExclusionPatterns;
    }

    private static Pattern loadPattern(JsonReader reader) throws IOException {
        return Pattern.compile(reader.nextString());
    }

    private static void savePattern(JsonWriter writer, Pattern pattern) throws IOException {
        writer.value(pattern.pattern());
    }

    private static void loadPatternSet(JsonReader reader, Set<Pattern> set) throws IOException {
        reader.beginArray();
        set.clear();
        while (true) {
            switch (reader.peek()) {
                case END_ARRAY: {
                    reader.endArray();
                    return;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
            set.add(NoCaves.loadPattern(reader));
        }
    }

    private static void savePatternSet(JsonWriter writer, Set<Pattern> set) throws IOException {
        writer.beginArray();
        for (Pattern p : set) {
            NoCaves.savePattern(writer, p);
        }
        writer.endArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load(File configFile) {
        try (JsonReader reader = new JsonReader((Reader)new FileReader(configFile));){
            reader.setLenient(true);
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                boolean bl = false;
                return bl;
            }
            reader.beginObject();
            long bitfield = 0L;
            block34: while (reader.peek() == JsonToken.NAME) {
                switch (reader.nextName()) {
                    case "enableCarverFilter": {
                        NoCaves.setEnableCarverFilter(reader.nextBoolean());
                        bitfield |= 1L;
                        continue block34;
                    }
                    case "disabledCarverPatterns": {
                        NoCaves.loadPatternSet(reader, NoCaves.getDisabledCarverPatterns());
                        bitfield |= 2L;
                        continue block34;
                    }
                    case "carverFilterBiomeExclusionPatterns": {
                        NoCaves.loadPatternSet(reader, NoCaves.getCarverFilterBiomeExclusionPatterns());
                        bitfield |= 4L;
                        continue block34;
                    }
                    case "enableDensityFunctionTransformation": {
                        NoCaves.setEnableDensityFunctionTransformation(reader.nextBoolean());
                        bitfield |= 8L;
                        continue block34;
                    }
                    case "densityFunctionToTransformPatterns": {
                        NoCaves.loadPatternSet(reader, NoCaves.getDensityFunctionToTransformPatterns());
                        bitfield |= 0x10L;
                        continue block34;
                    }
                    case "enableFinalDensityTransformation": {
                        NoCaves.setEnableFinalDensityTransformation(reader.nextBoolean());
                        bitfield |= 0x20L;
                        continue block34;
                    }
                    case "finalDensityTransformationExclusionPatterns": {
                        NoCaves.loadPatternSet(reader, NoCaves.getFinalDensityTransformationExclusionPatterns());
                        bitfield |= 0x40L;
                        continue block34;
                    }
                    case "enableNoiseCavesFilter": {
                        DensityFunctionCaveCleaner.setEnableNoiseCaveFilter(reader.nextBoolean());
                        bitfield |= 0x80L;
                        continue block34;
                    }
                    case "noiseCavePatterns": {
                        NoCaves.loadPatternSet(reader, DensityFunctionCaveCleaner.getNoiseCavePatterns());
                        bitfield |= 0x100L;
                        continue block34;
                    }
                    case "enableDensityFunctionCavesFilter": {
                        DensityFunctionCaveCleaner.setEnableDensityFunctionCaveFilter(reader.nextBoolean());
                        bitfield |= 0x200L;
                        continue block34;
                    }
                    case "densityFunctionCavePatterns": {
                        NoCaves.loadPatternSet(reader, DensityFunctionCaveCleaner.getDensityFunctionCavePatterns());
                        bitfield |= 0x400L;
                        continue block34;
                    }
                }
                reader.skipValue();
            }
            boolean bl = ((bitfield ^ 0xFFFFFFFFFFFFFFFFL) & 0x7FFL) == 0L;
            return bl;
        }
        catch (Exception e) {
            LOGGER.info("Failed to read config: {}", (Object)e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean save(File configFile) {
        boolean bl;
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));
        try {
            writer.setHtmlSafe(false);
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("enableCarverFilter");
            writer.value(NoCaves.isEnableCarverFilter());
            writer.name("disabledCarverPatterns");
            NoCaves.savePatternSet(writer, NoCaves.getDisabledCarverPatterns());
            writer.name("carverFilterBiomeExclusionPatterns");
            NoCaves.savePatternSet(writer, NoCaves.getCarverFilterBiomeExclusionPatterns());
            writer.name("enableDensityFunctionTransformation");
            writer.value(NoCaves.isEnableCarverFilter());
            writer.name("densityFunctionToTransformPatterns");
            NoCaves.savePatternSet(writer, NoCaves.getDensityFunctionToTransformPatterns());
            writer.name("enableFinalDensityTransformation");
            writer.value(NoCaves.isEnableFinalDensityTransformation());
            writer.name("finalDensityTransformationExclusionPatterns");
            NoCaves.savePatternSet(writer, NoCaves.getFinalDensityTransformationExclusionPatterns());
            writer.name("enableNoiseCaveFilter");
            writer.value(DensityFunctionCaveCleaner.isEnableNoiseCaveFilter());
            writer.name("noiseCavePatterns");
            NoCaves.savePatternSet(writer, DensityFunctionCaveCleaner.getNoiseCavePatterns());
            writer.name("enableDensityFunctionCaveFilter");
            writer.value(DensityFunctionCaveCleaner.isEnableDensityFunctionCaveFilter());
            writer.name("densityFunctionCavePatterns");
            NoCaves.savePatternSet(writer, DensityFunctionCaveCleaner.getDensityFunctionCavePatterns());
            writer.endObject();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.warn("Failed to write config: {}", (Object)e.getLocalizedMessage());
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public static void init() {
        File configFile = NoCaves.getConfigPath().toFile();
        if (!NoCaves.load(configFile)) {
            NoCaves.save(configFile);
        }
    }
}

