/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.api.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.capability.InvalidHardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfigData;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.mixin.ServerPlayerAccessor;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.blay09.mods.hardcorerevival.network.RevivalSuccessMessage;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2378;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class HardcoreRevivalManager {
    public static final class_5321<class_8110> NOT_RESCUED_IN_TIME = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)new class_2960("hardcorerevival", "not_rescued_in_time"));

    public HardcoreRevivalData getRevivalData(class_1657 player) {
        HardcoreRevivalData provider = (HardcoreRevivalData)Balm.getProviders().getProvider((class_1297)player, HardcoreRevivalData.class);
        return provider != null ? provider : InvalidHardcoreRevivalData.INSTANCE;
    }

    public void knockout(class_1657 player, class_1282 source) {
        MinecraftServer server;
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        if (revivalData.isKnockedOut()) {
            return;
        }
        player.method_6021();
        player.method_5848();
        player.method_6016(class_1294.field_5924);
        revivalData.setKnockedOut(true);
        revivalData.setKnockoutTicksPassed(0);
        Balm.getEvents().fireEvent((Object)new PlayerKnockedOutEvent(player, source));
        if (player.method_37908().method_8450().method_8355(class_1928.field_19398) && (server = player.method_5682()) != null) {
            class_270 team = player.method_5781();
            if (team != null && team.method_1200() != class_270.class_272.field_1442) {
                if (team.method_1200() == class_270.class_272.field_1444) {
                    server.method_3760().method_14564(player, player.method_6066().method_5548());
                } else if (team.method_1200() == class_270.class_272.field_1446) {
                    server.method_3760().method_14565(player, player.method_6066().method_5548());
                }
            } else {
                server.method_3760().method_43514(player.method_6066().method_5548(), false);
            }
        }
        this.updateKnockoutEffects(player);
    }

    public void wakeup(class_1657 player) {
        this.wakeup(player, true);
    }

    public void wakeup(class_1657 player, boolean applyEffects) {
        this.reset(player);
        if (applyEffects) {
            HardcoreRevivalConfigData config = HardcoreRevivalConfig.getActive();
            player.method_6033((float)config.rescueRespawnHealth);
            player.method_7344().method_7580(config.rescueRespawnFoodLevel);
            for (String effectString : config.rescueRespawnEffects) {
                String[] parts = effectString.split("\\|");
                class_2960 registryName = class_2960.method_12829((String)parts[0]);
                if (registryName != null) {
                    class_1291 effect = Balm.getRegistries().getMobEffect(registryName);
                    if (effect != null) {
                        int duration = this.tryParseInt(parts.length >= 2 ? parts[1] : null, 600);
                        int amplifier = this.tryParseInt(parts.length >= 3 ? parts[2] : null, 0);
                        player.method_6092(new class_1293(effect, duration, amplifier));
                        continue;
                    }
                    HardcoreRevival.logger.info("Invalid rescue potion effect '{}'" + parts[0]);
                    continue;
                }
                HardcoreRevival.logger.info("Invalid rescue potion effect '{}'" + parts[0]);
            }
        }
    }

    private int tryParseInt(@Nullable String text, int defaultVal) {
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public void finishRescue(class_1657 player) {
        MinecraftServer server;
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        class_1657 rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null && (server = rescueTarget.method_5682()) != null) {
            this.wakeup(rescueTarget);
            Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(rescueTarget.method_5628(), -1.0f));
            Balm.getNetworking().sendTo(rescueTarget, (Object)new RevivalSuccessMessage(rescueTarget.method_5628()));
            Balm.getNetworking().sendToTracking((class_1297)rescueTarget, (Object)new RevivalSuccessMessage(rescueTarget.method_5628()));
            revivalData.setRescueTarget(null);
        }
        Balm.getHooks().setForcedPose(player, null);
    }

    public void abortRescue(class_1657 player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        class_1657 rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null) {
            revivalData.setRescueTime(0);
            revivalData.setRescueTarget(null);
            Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(-1, -1.0f));
            KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, (class_1297)rescueTarget, this.getRevivalData(rescueTarget));
            Balm.getHooks().setForcedPose(player, null);
        }
    }

    public void notRescuedInTime(class_1657 player) {
        if (player instanceof ServerPlayerAccessor) {
            ServerPlayerAccessor accessor = (ServerPlayerAccessor)player;
            accessor.setSpawnInvulnerableTime(0);
        }
        class_2378 damageTypes = player.method_37908().method_30349().method_30530(class_7924.field_42534);
        class_1282 damageSource = new class_1282((class_6880)damageTypes.method_40290(NOT_RESCUED_IN_TIME));
        player.method_5643(damageSource, Float.MAX_VALUE);
        this.reset(player);
    }

    public void reset(class_1657 player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        revivalData.setKnockedOut(false);
        revivalData.setKnockoutTicksPassed(0);
        this.updateKnockoutEffects(player);
    }

    public void updateKnockoutEffects(class_1657 player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        if (HardcoreRevivalConfig.getActive().glowOnKnockout) {
            player.method_5834(revivalData.isKnockedOut());
        }
        Balm.getHooks().setForcedPose(player, (class_4050)(revivalData.isKnockedOut() ? class_4050.field_18077 : null));
        KnockoutSyncHandler.sendHardcoreRevivalDataToWatching(player, revivalData);
    }

    public void startRescue(class_1657 player, class_1657 target) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        revivalData.setRescueTarget(target);
        revivalData.setRescueTime(0);
        Balm.getNetworking().sendTo(player, (Object)new RevivalProgressMessage(target.method_5628(), 0.1f));
        KnockoutSyncHandler.sendHardcoreRevivalData(target, (class_1297)target, this.getRevivalData(target), true);
        Balm.getHooks().setForcedPose(player, class_4050.field_18081);
    }

    public boolean isRescuing(class_1657 player) {
        HardcoreRevivalData revivalData = this.getRevivalData(player);
        class_1657 rescueTarget = revivalData.getRescueTarget();
        return rescueTarget != null;
    }

    boolean isKnockedOut(class_1657 player) {
        return this.getRevivalData(player).isKnockedOut();
    }
}

