/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import java.util.Objects;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingDamageEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.mixin.LivingEntityAccessor;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;

public class KnockoutHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(LivingDamageEvent.class, KnockoutHandler::onPlayerDamage);
        Balm.getEvents().onEvent(PlayerRespawnEvent.class, KnockoutHandler::onPlayerRespawn);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, KnockoutHandler::onPlayerTick);
    }

    public static void onPlayerDamage(LivingDamageEvent event) {
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_3222) {
            boolean canDamageSourceKnockout;
            class_3222 player = (class_3222)class_13092;
            class_1282 damageSource = event.getDamageSource();
            if (HardcoreRevival.getRevivalData((class_1297)event.getEntity()).isKnockedOut()) {
                class_1297 attacker = damageSource.method_5529();
                if (attacker instanceof class_1308) {
                    class_1308 mob = (class_1308)attacker;
                    mob.method_5980(null);
                }
                if (!damageSource.method_48789(class_8103.field_42242) && !damageSource.method_49708(HardcoreRevivalManager.NOT_RESCUED_IN_TIME)) {
                    event.setCanceled(true);
                }
                return;
            }
            boolean bl = canDamageSourceKnockout = !damageSource.method_49708(class_8111.field_42347) && !damageSource.method_49708(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
            if (canDamageSourceKnockout && KnockoutHandler.isKnockoutEnabledFor(player, damageSource) && player.method_6032() - event.getDamageAmount() <= 0.0f) {
                event.setDamageAmount(Math.min(event.getDamageAmount(), Math.max(0.0f, player.method_6032() - 1.0f)));
                if (((LivingEntityAccessor)player).callCheckTotemDeathProtection(damageSource)) {
                    event.setCanceled(true);
                } else {
                    HardcoreRevival.getManager().knockout((class_1657)player, damageSource);
                }
            }
        }
    }

    private static boolean isKnockoutEnabledFor(class_3222 player, class_1282 damageSource) {
        class_2960 entityTypeId;
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        boolean canDamageSourceKnockout = !damageSource.method_49708(class_8111.field_42347) && !damageSource.method_49708(HardcoreRevivalManager.NOT_RESCUED_IN_TIME);
        class_2960 damageSourceId = player.method_5682().method_30611().method_30530(class_7924.field_42534).method_10221((Object)damageSource.method_48792());
        if (!canDamageSourceKnockout || HardcoreRevivalConfig.getActive().instantDeathSources.contains(Objects.toString(damageSourceId))) {
            return false;
        }
        class_1297 attacker = damageSource.method_5529();
        if (attacker != null && HardcoreRevivalConfig.getActive().instantDeathEntityTypes.contains(Objects.toString(entityTypeId = class_7923.field_41177.method_10221((Object)attacker.method_5864())))) {
            return false;
        }
        if (HardcoreRevivalConfig.getActive().disableInSingleplayer && server.method_3724() && server.method_3788() == 1) {
            return false;
        }
        return !HardcoreRevivalConfig.getActive().disableInLonelyMultiplayer || server.method_3724() || server.method_3788() != 1;
    }

    public static void onPlayerTick(class_3222 player) {
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((class_1297)player);
        if (revivalData.isKnockedOut() && player.method_5805()) {
            int maxTicksUntilDeath;
            player.method_6033(1.0f);
            revivalData.setKnockoutTicksPassed(revivalData.getKnockoutTicksPassed() + 1);
            if (player.field_6012 % 20 == 0) {
                Balm.getHooks().setForcedPose((class_1657)player, (class_4050)(revivalData.isKnockedOut() ? class_4050.field_18077 : null));
            }
            if ((maxTicksUntilDeath = HardcoreRevivalConfig.getActive().ticksUntilDeath) > 0 && revivalData.getKnockoutTicksPassed() >= maxTicksUntilDeath) {
                HardcoreRevival.getManager().notRescuedInTime((class_1657)player);
            }
        }
    }

    public static void onPlayerRespawn(PlayerRespawnEvent event) {
        HardcoreRevival.getManager().reset((class_1657)event.getNewPlayer());
    }
}

