/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.DigSpeedEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.LivingHealEvent;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.tag.ModBlockTags;
import net.blay09.mods.hardcorerevival.tag.ModItemTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class KnockoutRestrictionHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseBlockEvent.class, KnockoutRestrictionHandler::onUseBlock, EventPriority.Highest);
        Balm.getEvents().onEvent(UseItemEvent.class, KnockoutRestrictionHandler::onUseItem, EventPriority.Highest);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, KnockoutRestrictionHandler::onAttack, EventPriority.Highest);
        Balm.getEvents().onEvent(DigSpeedEvent.class, KnockoutRestrictionHandler::onDigSpeed, EventPriority.Highest);
        Balm.getEvents().onEvent(LivingHealEvent.class, KnockoutRestrictionHandler::onHeal);
    }

    public static void onHeal(LivingHealEvent event) {
        class_1657 player;
        class_1309 class_13092 = event.getEntity();
        if (class_13092 instanceof class_1657 && HardcoreRevival.getRevivalData((class_1297)(player = (class_1657)class_13092)).isKnockedOut()) {
            event.setCanceled(false);
        }
    }

    public static void onDigSpeed(DigSpeedEvent event) {
        class_1657 player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut() && !KnockoutRestrictionHandler.mayBreakBlockKnockedOut(event.getState())) {
            event.setSpeedOverride(Float.valueOf(0.0f));
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        class_1657 player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            class_1799 itemStack = player.method_5998(event.getHand());
            class_1937 level = event.getLevel();
            class_2338 pos = event.getHitResult().method_17777();
            if (!KnockoutRestrictionHandler.mayUseItemKnockedOut(itemStack) && !KnockoutRestrictionHandler.mayUseBlockKnockedOut(level, pos, itemStack)) {
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItem(UseItemEvent event) {
        class_1799 itemStack;
        class_1657 player = event.getPlayer();
        if (HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut() && !KnockoutRestrictionHandler.mayUseItemKnockedOut(itemStack = player.method_5998(event.getHand()))) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        class_1657 player = event.getPlayer();
        if (player != null && HardcoreRevival.getRevivalData((class_1297)player).isKnockedOut()) {
            class_1799 itemStack = player.method_6047();
            if (HardcoreRevivalConfig.getActive().allowUnarmedMelee && itemStack.method_7960()) {
                return;
            }
            if (!KnockoutRestrictionHandler.mayAttackWithItemKnockedOut(itemStack)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean mayUseItemKnockedOut(class_1799 itemStack) {
        if (HardcoreRevivalConfig.getActive().allowBows && itemStack.method_7909() instanceof class_1753) {
            return true;
        }
        return itemStack.method_31573(ModItemTags.ALLOW_USE_WHILE_KNOCKED_OUT);
    }

    public static boolean mayTossItemKnockedOut(class_1799 itemStack) {
        return itemStack.method_31573(ModItemTags.ALLOW_TOSS_WHILE_KNOCKED_OUT);
    }

    private static boolean mayAttackWithItemKnockedOut(class_1799 itemStack) {
        return itemStack.method_31573(ModItemTags.ALLOW_ATTACK_WHILE_KNOCKED_OUT);
    }

    private static boolean mayUseBlockKnockedOut(class_1937 level, class_2338 pos, class_1799 itemStack) {
        if (!itemStack.method_7960()) {
            return false;
        }
        return level.method_8320(pos).method_26164(ModBlockTags.ALLOW_USE_WHILE_KNOCKED_OUT);
    }

    private static boolean mayBreakBlockKnockedOut(class_2680 state) {
        return state.method_26164(ModBlockTags.ALLOW_BREAK_WHILE_KNOCKED_OUT);
    }
}

