/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.handler;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.PlayerAttackEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class RescueHandler {
    public static void initialize() {
        Balm.getEvents().onEvent(UseItemEvent.class, RescueHandler::onUseItem);
        Balm.getEvents().onEvent(UseBlockEvent.class, RescueHandler::onUseBlock);
        Balm.getEvents().onEvent(PlayerAttackEvent.class, RescueHandler::onAttack);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.End, RescueHandler::onPlayerTick);
    }

    public static void onUseItem(UseItemEvent event) {
        if (HardcoreRevival.getManager().isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onUseBlock(UseBlockEvent event) {
        if (HardcoreRevival.getManager().isRescuing(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    public static void onAttack(PlayerAttackEvent event) {
        HardcoreRevival.getManager().abortRescue(event.getPlayer());
    }

    public static void onPlayerTick(class_3222 player) {
        HardcoreRevivalData revivalData = HardcoreRevival.getRevivalData((class_1297)player);
        class_1657 rescueTarget = revivalData.getRescueTarget();
        if (rescueTarget != null) {
            HardcoreRevivalData rescueTargetData = HardcoreRevival.getRevivalData((class_1297)rescueTarget);
            int knockoutTicksPassed = rescueTargetData.getKnockoutTicksPassed();
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().ticksUntilDeath;
            if (!rescueTarget.method_5805() || maxTicksUntilDeath > 0 && knockoutTicksPassed >= maxTicksUntilDeath) {
                HardcoreRevival.getManager().abortRescue((class_1657)player);
            } else {
                float dist = player.method_5739((class_1297)rescueTarget);
                if ((double)dist > HardcoreRevivalConfig.getActive().rescueDistance) {
                    HardcoreRevival.getManager().abortRescue((class_1657)player);
                } else {
                    int rescueTime = revivalData.getRescueTime() + 1;
                    revivalData.setRescueTime(rescueTime);
                    rescueTargetData.setKnockoutTicksPassed(knockoutTicksPassed - 1);
                    int maxRescueActionTicks = HardcoreRevivalConfig.getActive().rescueActionTicks;
                    int step = maxRescueActionTicks / 4;
                    if (rescueTime >= maxRescueActionTicks) {
                        HardcoreRevival.getManager().finishRescue((class_1657)player);
                    } else if (rescueTime % step == 0) {
                        Balm.getNetworking().sendTo((class_1657)player, (Object)new RevivalProgressMessage(rescueTarget.method_5628(), (float)rescueTime / (float)maxRescueActionTicks));
                        KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, (class_1297)rescueTarget, rescueTargetData, true);
                    }
                }
            }
        }
    }
}

