/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.api.PlayerKnockedOutEvent;
import net.blay09.mods.hardcorerevival.api.PlayerRescuedEvent;
import net.blay09.mods.hardcorerevival.api.PlayerRevivedEvent;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.network.RevivalProgressMessage;
import net.blay09.mods.hardcorerevival.network.RevivalSuccessMessage;
import net.blay09.mods.hardcorerevival.stats.ModStats;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2378;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class HardcoreRevivalManager {
    public static final class_5321<class_8110> NOT_RESCUED_IN_TIME = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)class_2960.method_60655((String)"hardcorerevival", (String)"not_rescued_in_time"));

    public static void knockout(class_3222 player, class_1282 source) {
        MinecraftServer server;
        boolean isConsecutiveKnockout;
        if (PlayerHardcoreRevivalManager.isKnockedOut((class_1657)player)) {
            return;
        }
        player.method_7346();
        player.method_6021();
        player.method_5848();
        player.method_6016(class_1294.field_5924);
        PlayerHardcoreRevivalManager.setKnockedOut((class_1657)player, true);
        PlayerHardcoreRevivalManager.setKnockoutTicksPassed((class_1657)player, 0);
        PlayerHardcoreRevivalManager.setLastKnockoutAt((class_1657)player, System.currentTimeMillis());
        player.method_7281(ModStats.knockouts);
        long lastRescuedAt = PlayerHardcoreRevivalManager.getLastRescuedAt((class_1657)player);
        int consecutiveThresholdSeconds = HardcoreRevivalConfig.getActive().consecutiveKnockoutThresholdSeconds;
        long secondsSinceLastRescue = (System.currentTimeMillis() - lastRescuedAt) / 1000L;
        boolean bl = isConsecutiveKnockout = consecutiveThresholdSeconds > 0 && lastRescuedAt > 0L && secondsSinceLastRescue <= (long)consecutiveThresholdSeconds;
        if (isConsecutiveKnockout) {
            if (HardcoreRevivalConfig.getActive().resumeTimerOnConsecutiveKnockout) {
                PlayerHardcoreRevivalManager.setKnockoutTicksPassed((class_1657)player, PlayerHardcoreRevivalManager.getLastKnockoutTicksPassed((class_1657)player));
            }
            float multiplyTimerOnConsecutiveKnockout = HardcoreRevivalConfig.getActive().multiplyTimerOnConsecutiveKnockout;
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20;
            int ticksLeft = maxTicksUntilDeath - PlayerHardcoreRevivalManager.getKnockoutTicksPassed((class_1657)player);
            int newTicksLeft = (int)((float)ticksLeft * multiplyTimerOnConsecutiveKnockout);
            PlayerHardcoreRevivalManager.setKnockoutTicksPassed((class_1657)player, maxTicksUntilDeath - newTicksLeft);
        }
        Balm.getEvents().fireEvent((Object)new PlayerKnockedOutEvent((class_1657)player, source));
        if (player.method_51469().method_64395().method_8355(class_1928.field_19398) && (server = player.method_51469().method_8503()) != null) {
            class_268 team = player.method_5781();
            if (team != null && team.method_1200() != class_270.class_272.field_1442) {
                if (team.method_1200() == class_270.class_272.field_1444) {
                    server.method_3760().method_14564((class_1657)player, player.method_6066().method_5548());
                } else if (team.method_1200() == class_270.class_272.field_1446) {
                    server.method_3760().method_14565((class_1657)player, player.method_6066().method_5548());
                }
            } else {
                server.method_3760().method_43514(player.method_6066().method_5548(), false);
            }
        }
        HardcoreRevivalManager.updateKnockoutEffects((class_1657)player);
    }

    public static void wakeup(class_1657 player) {
        HardcoreRevivalManager.wakeup(player, true);
    }

    public static void wakeup(class_1657 player, boolean applyEffects) {
        PlayerHardcoreRevivalManager.setLastRescuedAt(player, System.currentTimeMillis());
        PlayerHardcoreRevivalManager.setLastKnockoutTicksPassed(player, PlayerHardcoreRevivalManager.getKnockoutTicksPassed(player));
        HardcoreRevivalManager.reset(player);
        if (applyEffects) {
            HardcoreRevivalConfig config = HardcoreRevivalConfig.getActive();
            player.method_6033((float)config.rescueRespawnHealth);
            player.method_7344().method_7580(config.rescueRespawnFoodLevel);
            for (String effectString : config.rescueRespawnEffects) {
                String[] parts = effectString.split("\\|");
                class_2960 registryName = class_2960.method_12829((String)parts[0]);
                if (registryName != null) {
                    Optional holder = class_7923.field_41174.method_10223(registryName);
                    if (holder.isPresent()) {
                        int duration = HardcoreRevivalManager.tryParseInt(parts.length >= 2 ? parts[1] : null, 600);
                        int amplifier = HardcoreRevivalManager.tryParseInt(parts.length >= 3 ? parts[2] : null, 0);
                        player.method_6092(new class_1293((class_6880)holder.get(), duration, amplifier));
                        continue;
                    }
                    HardcoreRevival.logger.info("Invalid rescue potion effect '{}'", (Object)parts[0]);
                    continue;
                }
                HardcoreRevival.logger.info("Invalid rescue potion effect '{}'", (Object)parts[0]);
            }
        }
        Balm.getEvents().fireEvent((Object)new PlayerRevivedEvent(player));
    }

    private static int tryParseInt(@Nullable String text, int defaultVal) {
        if (text != null) {
            try {
                return Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    public static void finishRescue(class_1657 player) {
        MinecraftServer server;
        class_1657 rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        if (rescueTarget != null && (server = rescueTarget.method_73183().method_8503()) != null) {
            HardcoreRevivalManager.wakeup(rescueTarget);
            Balm.getNetworking().sendTo(player, (class_8710)new RevivalProgressMessage(rescueTarget.method_5628(), -1.0f));
            Balm.getNetworking().sendTo(rescueTarget, (class_8710)new RevivalSuccessMessage(rescueTarget.method_5628()));
            Balm.getNetworking().sendToTracking((class_1297)rescueTarget, (class_8710)new RevivalSuccessMessage(rescueTarget.method_5628()));
            PlayerHardcoreRevivalManager.setRescueTarget(player, null);
            Balm.getEvents().fireEvent((Object)new PlayerRescuedEvent(rescueTarget, player));
        }
        Balm.getHooks().setForcedPose(player, null);
    }

    public static void abortRescue(class_1657 player) {
        class_1657 rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        if (rescueTarget != null) {
            PlayerHardcoreRevivalManager.setRescueTime(player, 0);
            PlayerHardcoreRevivalManager.setRescueTarget(player, null);
            Balm.getNetworking().sendTo(player, (class_8710)new RevivalProgressMessage(-1, -1.0f));
            KnockoutSyncHandler.sendHardcoreRevivalData(rescueTarget, rescueTarget);
            Balm.getHooks().setForcedPose(player, null);
        }
    }

    public static void notRescuedInTime(class_1657 player) {
        class_2378 damageTypes = player.method_73183().method_30349().method_30530(class_7924.field_42534);
        class_1282 damageSource = new class_1282((class_6880)damageTypes.method_46747(NOT_RESCUED_IN_TIME));
        PlayerHardcoreRevivalManager.setLastKnockoutTicksPassed(player, 0);
        HardcoreRevivalManager.reset(player);
        player.method_64419(damageSource, Float.MAX_VALUE);
    }

    public static void reset(class_1657 player) {
        PlayerHardcoreRevivalManager.setKnockedOut(player, false);
        PlayerHardcoreRevivalManager.setKnockoutTicksPassed(player, 0);
        HardcoreRevivalManager.updateKnockoutEffects(player);
    }

    public static void updateKnockoutEffects(class_1657 player) {
        if (HardcoreRevivalConfig.getActive().glowOnKnockout) {
            player.method_5834(PlayerHardcoreRevivalManager.isKnockedOut(player));
        }
        Balm.getHooks().setForcedPose(player, (class_4050)(PlayerHardcoreRevivalManager.isKnockedOut(player) ? class_4050.field_18077 : null));
        KnockoutSyncHandler.sendHardcoreRevivalDataToWatching(player);
    }

    public static void startRescue(class_1657 player, class_1657 target) {
        PlayerHardcoreRevivalManager.setRescueTarget(player, target);
        PlayerHardcoreRevivalManager.setRescueTime(player, 0);
        Balm.getNetworking().sendTo(player, (class_8710)new RevivalProgressMessage(target.method_5628(), 0.1f));
        KnockoutSyncHandler.sendHardcoreRevivalData(target, target, true);
        Balm.getHooks().setForcedPose(player, class_4050.field_18081);
    }

    public static boolean isRescuing(class_1657 player) {
        class_1657 rescueTarget = PlayerHardcoreRevivalManager.getRescueTarget(player);
        return rescueTarget != null;
    }

    public static boolean isKnockedOut(class_1657 player) {
        return PlayerHardcoreRevivalManager.isKnockedOut(player);
    }
}

