/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.proxy.SidedProxy;
import net.blay09.mods.hardcorerevival.HardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalDataImpl;
import net.blay09.mods.hardcorerevival.capability.InvalidHardcoreRevivalData;
import net.blay09.mods.hardcorerevival.command.ReviveCommand;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.KnockoutHandler;
import net.blay09.mods.hardcorerevival.handler.KnockoutRestrictionHandler;
import net.blay09.mods.hardcorerevival.handler.KnockoutSyncHandler;
import net.blay09.mods.hardcorerevival.handler.LoginLogoutHandler;
import net.blay09.mods.hardcorerevival.handler.RescueHandler;
import net.blay09.mods.hardcorerevival.network.ModNetworking;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HardcoreRevival {
    public static final String MOD_ID = "hardcorerevival";
    private static final SidedProxy<HardcoreRevivalManager> manager = Balm.sidedProxy((String)"net.blay09.mods.hardcorerevival.HardcoreRevivalManager", (String)"net.blay09.mods.hardcorerevival.client.HardcoreRevivalClientManager");
    private static final HardcoreRevivalData clientRevivalData = new HardcoreRevivalDataImpl();
    public static final Logger logger = LogManager.getLogger();

    public static void initialize() {
        HardcoreRevivalConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.getCommands().register(ReviveCommand::register);
        KnockoutHandler.initialize();
        KnockoutSyncHandler.initialize();
        KnockoutRestrictionHandler.initialize();
        LoginLogoutHandler.initialize();
        RescueHandler.initialize();
        Balm.initializeIfLoaded((String)"cgm", (String)"net.blay09.mods.hardcorerevival.compat.MrCrayfishsGunModAddon");
    }

    public static HardcoreRevivalManager getManager() {
        return (HardcoreRevivalManager)manager.get();
    }

    public static HardcoreRevivalData getRevivalData(Entity entity) {
        HardcoreRevivalData hardcoreRevivalData;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            hardcoreRevivalData = HardcoreRevival.getManager().getRevivalData(player);
        } else {
            hardcoreRevivalData = InvalidHardcoreRevivalData.INSTANCE;
        }
        return hardcoreRevivalData;
    }

    public static HardcoreRevivalData getClientRevivalData() {
        return clientRevivalData;
    }
}

