/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival;

import net.blay09.mods.hardcorerevival.InMemoryRevivalDataProvider;
import net.blay09.mods.hardcorerevival.PersistentRevivalDataProvider;
import net.blay09.mods.hardcorerevival.RevivalDataProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class PlayerHardcoreRevivalManager {
    private static final RevivalDataProvider persistentDataProvider = new PersistentRevivalDataProvider();
    private static final RevivalDataProvider inMemoryDataProvider = new InMemoryRevivalDataProvider();

    public static RevivalDataProvider getRevivalDataProvider(@Nullable Level world) {
        return world == null || world.isClientSide ? inMemoryDataProvider : persistentDataProvider;
    }

    public static void setKnockedOut(Player player, boolean knockedOut) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setKnockedOut(player, knockedOut);
    }

    public static boolean isKnockedOut(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).isKnockedOut(player);
    }

    public static void setKnockoutTicksPassed(Player player, int knockoutTicksPassed) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setKnockoutTicksPassed(player, knockoutTicksPassed);
    }

    public static int getKnockoutTicksPassed(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getKnockoutTicksPassed(player);
    }

    public static void setLastKnockoutTicksPassed(Player player, int lastKnockoutTicksPassed) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setLastKnockoutTicksPassed(player, lastKnockoutTicksPassed);
    }

    public static int getLastKnockoutTicksPassed(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getLastKnockoutTicksPassed(player);
    }

    public static void setLastRescuedAt(Player player, long lastRescuedAt) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setLastRescuedAt(player, lastRescuedAt);
    }

    public static long getLastRescuedAt(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getLastRescuedAt(player);
    }

    public static void setLastKnockoutAt(Player player, long lastKnockoutAt) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setLastKnockoutAt(player, lastKnockoutAt);
    }

    public static long getLastKnockoutAt(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getLastKnockoutAt(player);
    }

    public static void setLastLogoutAt(Player player, long lastLogoutAt) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setLastLogoutAt(player, lastLogoutAt);
    }

    public static long getLastLogoutAt(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getLastLogoutAt(player);
    }

    public static void setRescueTime(Player player, int rescueTime) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setRescueTime(player, rescueTime);
    }

    public static int getRescueTime(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getRescueTime(player);
    }

    public static void setRescueTarget(Player player, @Nullable Player rescueTarget) {
        PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).setRescueTarget(player, rescueTarget);
    }

    @Nullable
    public static Player getRescueTarget(Player player) {
        return PlayerHardcoreRevivalManager.getRevivalDataProvider(player.level()).getRescueTarget(player);
    }
}

