/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.hardcorerevival.PlayerHardcoreRevivalManager;
import net.blay09.mods.hardcorerevival.config.HardcoreRevivalConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;

public class GuiHelper {
    public static void drawGradientRectW(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int startColor, int endColor) {
        guiGraphics.fillGradient(left, top, right, bottom, startColor, endColor);
    }

    public static void renderKnockedOutTitle(GuiGraphics guiGraphics, int width) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, I18n.get((String)"gui.hardcorerevival.knocked_out", (Object[])new Object[0]), width / 2 / 2, 30, 0xFFFFFF);
        poseStack.popPose();
    }

    public static void renderDeathTimer(GuiGraphics guiGraphics, int width, int height, boolean beingRescued) {
        Font font = Minecraft.getInstance().font;
        if (beingRescued) {
            guiGraphics.drawCenteredString(font, I18n.get((String)"gui.hardcorerevival.being_rescued", (Object[])new Object[0]), width / 2, height / 2 + 10, 0xFFFFFF);
        } else {
            int maxTicksUntilDeath = HardcoreRevivalConfig.getActive().secondsUntilDeath * 20;
            if (maxTicksUntilDeath > 0) {
                int deathSecondsLeft = Math.max(0, (maxTicksUntilDeath - PlayerHardcoreRevivalManager.getKnockoutTicksPassed((Player)Minecraft.getInstance().player)) / 20);
                guiGraphics.drawCenteredString(font, I18n.get((String)"gui.hardcorerevival.rescue_time_left", (Object[])new Object[]{deathSecondsLeft}), width / 2, height / 2 + 10, 0xFFFFFF);
            } else {
                guiGraphics.drawCenteredString(font, I18n.get((String)"gui.hardcorerevival.wait_for_rescue", (Object[])new Object[0]), width / 2, height / 2 + 10, 0xFFFFFF);
            }
        }
    }
}

